/*
 * strftime.h
 *   header file for strftime.c
 *
 * $Id: strftime.h,v 1.6 2003/01/29 05:48:41 wcc Exp $
 */
/* 
 * Copyright (C) 2000, 2001, 2002, 2003 Eggheads Development Team
 * Written by Fabian Knittel
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _EGG_COMPAT_STRFTIME_H_
#define _EGG_COMPAT_STRFTIME_H_

#include "src/main.h"
#include <time.h>

/* Use the system libraries version of strftime() if available. Otherwise
 * use our own.
 */
#ifndef HAVE_STRFTIME
size_t egg_strftime(char *s, size_t maxsize, const char *format,
                    const struct tm *tp);
#else
#  define egg_strftime strftime
#endif

#endif /* !_EGG_COMPAT_STRFTIME_H_ */
