# Emacs: -*- mode: fundamental; coding: binary -*-

# Russian language file.
#
# IRC Services is copyright (c) 1996-2007 Andrew Church.
#     E-mail: <achurch@achurch.org>
# Parts written by Andrew Kempe and others.
# This program is free but copyrighted software; see the file COPYING for
# details.

# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, please inform
# the Services developers.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.
#
# Translated by Alexander Zverev, tty(at)inbox(dot)ru
#

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	 (Russian)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%d %b %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %d %b %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%d %b %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	
	
	
	
	
	
	
# %A
STRFTIME_DAYS_LONG
	
	
	
	
	
	
	
# %b
STRFTIME_MONTHS_SHORT
	
	
	
	
	
	
	
	
	
	
	
	
# %B
STRFTIME_MONTHS_LONG
	
	
	
	
	
	
	
	
	
	
	
	


# "day", "hour", "minute", and "second" in singular and plural.
# These must be preceded by spaces if the language requires them
# (e.g. in English: "10 hours", not "10hours").
STR_DAY
	 
STR_DAYS
	 
STR_HOUR
	 
STR_HOURS
	 
STR_MINUTE
	 
STR_MINUTES
	 
STR_SECOND
	 
STR_SECONDS
	 
# Separator used between units of time; in English, a comma followed by a
# space (the ", " in "3 hours, 10 minutes").
STR_TIMESEP
	,

# This is used in ChanServ/NickServ INFO displays, and is a comma followed
# by a space (", " -- trailing space is significant), or the equivalent in
# the language's character set.
COMMA_SPACE
	,


# Various error messages.
INTERNAL_ERROR
	  --   .
SERVICES_IS_BUSY
	    ; ,    .

UNKNOWN_COMMAND
	  %s.
UNKNOWN_COMMAND_HELP
	  %s.   /msg %s HELP   .
SYNTAX_ERROR
	: %s
MORE_INFO
	 /msg %s HELP %s   .
NO_HELP_AVAILABLE
	  %s .
MISSING_QUOTE
	    (").

BAD_EMAIL
	E-mail      username@hostname.      ,  , ,      : , : ; | \ " ( ) < > [ ]
BAD_URL
	URLs     http://hostname[:port]/... (or ftp://,  ..).
BAD_USERHOST_MASK
	     user@host.
BAD_NICKUSERHOST_MASK
	     nick!user@host.
BAD_EXPIRY_TIME
	  .

SENDMAIL_NO_RESOURCES
	    ,   ; ,    .
READ_ONLY_MODE
	:     ;    !
PASSWORD_INCORRECT
	 .
PASSWORD_WARNING
	:        .

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	  .
PERMISSION_DENIED
	 .

MORE_OBSCURE_PASSWORD
	,       .        ,      (..    ).
PASSWORD_TRUNCATED
	:       %d .

NICK_NOT_REGISTERED
	  .
NICK_NOT_REGISTERED_HELP
	  .   /msg %s HELP     ,   .
NICK_TOO_LONG
	     %d .
NICK_INVALID
	%s  .
NICK_X_NOT_REGISTERED
	 %s .
NICK_X_ALREADY_REGISTERED
	 %s  !
NICK_X_NOT_IN_USE
	 %s     .
NICK_X_FORBIDDEN
	 %s      .
NICK_X_SUSPENDED
	 %s       .
NICK_X_SUSPENDED_MEMOS
	 %s      .
NICK_IDENTIFY_REQUIRED
	     .
	     /msg %s IDENTIFY password.
NICK_PLEASE_AUTH
	    . ,    ,    e-mail: %s
NICK_X_NOT_ON_CHAN_X
	 %s     %s.

CHAN_INVALID
	%s   .
CHAN_X_NOT_REGISTERED
	 %s .
CHAN_X_NOT_IN_USE
	 %s  .
CHAN_X_FORBIDDEN
	 %s      .
CHAN_X_SUSPENDED
	 %s       .
CHAN_X_SUSPENDED_MEMOS
	 %s      .
CHAN_IDENTIFY_REQUIRED
	     .
	     /msg %s IDENTIFY %s password.

SERV_X_NOT_FOUND
	 %s  .

EXPIRES_NONE
	 
EXPIRES_SOON
	    
EXPIRES_IN
	 %s

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	   . ,   . (   ,  /msg %s IDENTIFY password.)
NICK_IS_SECURE
	    .    ,  /msg %s IDENTIFY password.    .
NICK_MAY_NOT_BE_USED
	    . ,  .
DISCONNECT_IN_1_MINUTE
	         ,   .
DISCONNECT_IN_20_SECONDS
	        20- ,   .
DISCONNECT_NOW
	  ,     . ,       .
FORCENICKCHANGE_IN_1_MINUTE
	         ,    .
FORCENICKCHANGE_IN_20_SECONDS
	        20- ,    .
FORCENICKCHANGE_NOW
	  ,     .       %s.
NICK_EXPIRES_SOON
	:     %s.        , ,   %s : /msg %s IDENTIFY password
NICK_EXPIRED
	:    . ,   ,       .
# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER  [email]
NICK_REGISTER_REQ_EMAIL_SYNTAX
	REGISTER  email
NICK_REGISTRATION_DISABLED
	,    .
NICK_REGISTRATION_FAILED
	,   .
NICK_REG_PLEASE_WAIT
	,  %s     REGISTER  .
NICK_REG_PLEASE_WAIT_FIRST
	,  %s     REGISTER.
NICK_CANNOT_BE_REGISTERED
	 %s    .
NICK_REGISTER_EMAIL_UNAUTHED
	  E-mail    . ,   AUTH    ,       .
NICK_REGISTER_TOO_MANY_NICKS
	     (%d,  %d).     ,       .
NICK_REGISTERED
	 %s   .
NICK_PASSWORD_IS
	  %s --     .

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY 
NICK_IDENTIFY_FAILED
	,   .
NICK_IDENTIFY_EMAIL_MISSING
	   E-mail      ,   . ,  e-mail : /msg %s SET EMAIL address
NICK_IDENTIFY_SUCCEEDED
	  -  .

# DROP responses
NICK_DROP_SYNTAX
	DROP 
NICK_DROP_WARNING
	:  DROP     !
NICK_DROP_DISABLED
	,    .
NICK_DROP_FAILED
	,   .
NICK_DROPPED
	   .
NICK_DROPPED_LINKS
	       .

# DROPNICK responses
NICK_DROPNICK_SYNTAX
	DROPNICK 
NICK_X_DROPPED
	 %s  .
NICK_X_DROPPED_LINKS
	 %s      .

# DROPEMAIL and DROPEMAIL-CONFIRM responses
NICK_DROPEMAIL_SYNTAX
	DROPEMAIL 
NICK_DROPEMAIL_PATTERN_TOO_LONG
	    ( %d ).
NICK_DROPEMAIL_NONE
	      E-mail ,    .
NICK_DROPEMAIL_COUNT
	 %d   E-mail ,    .
	   ,  /msg %s DROPEMAIL-CONFIRM %s
NICK_DROPEMAIL_CONFIRM_SYNTAX
	DROPEMAIL-CONFIRM 
NICK_DROPEMAIL_CONFIRM_UNKNOWN
	  . ,   DROPEMAIL         DROPEMAIL-CONFIRM.
NICK_DROPEMAIL_CONFIRM_DROPPING
	 %d ...
NICK_DROPEMAIL_CONFIRM_DROPPED
	  .

# SET responses
NICK_SET_SYNTAX
	SET  
NICK_SET_OPER_SYNTAX
	SET []  
NICK_SET_DISABLED
	,     .
NICK_SET_UNKNOWN_OPTION
	 SET  %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	 SET  %s,   .

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	,   .
NICK_SET_PASSWORD_CHANGED
	 .
NICK_SET_PASSWORD_CHANGED_TO
	   %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE 
NICK_SET_LANGUAGE_UNKNOWN
	   %d.   /msg %s HELP SET LANGUAGE    .
NICK_SET_LANGUAGE_CHANGED
	   %s.

# SET URL responses
NICK_SET_URL_CHANGED
	URL  %s   %s.

# SET EMAIL responses
NICK_SET_EMAIL_UNAUTHED
	  E-mail    . ,    AUTH    .
NICK_SET_EMAIL_TOO_MANY_NICKS
	%s   %d   ( %d).   E-mail   .
NICK_SET_EMAIL_CHANGED
	E-mail   %s   %s.

# SET INFO responses
NICK_SET_INFO_CHANGED
	  %s .

# SET KILL responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	  .
NICK_SET_KILL_QUICK
	     .
NICK_SET_KILL_IMMED
	  ,  .
NICK_SET_KILL_IMMED_DISABLED
	 IMMED    .
NICK_SET_KILL_OFF
	  .

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	 .
NICK_SET_SECURE_OFF
	 .

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	 .
NICK_SET_PRIVATE_OFF
	 .

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	 E-mail       %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	 E-mail     %s INFO.
NICK_SET_HIDE_MASK_ON
	   user@host      %s INFO.
NICK_SET_HIDE_MASK_OFF
	   user@host    %s INFO.
NICK_SET_HIDE_QUIT_ON
	    /QUIT      %s INFO.
NICK_SET_HIDE_QUIT_OFF
	    /QUIT    %s INFO.

# SET TIMEZONE responses
NICK_SET_TIMEZONE_SYNTAX
	SET TIMEZONE {UTC-offset | time-zone | DEFAULT}
NICK_SET_TIMEZONE_TO
	     UTC%c%d:%02d.
	     %s.
NICK_SET_TIMEZONE_DEFAULT
	    -,   .

# SET MAINNICK responses
NICK_SET_MAINNICK_NOT_FOUND
	 %s      .
NICK_SET_MAINNICK_CHANGED
	     %s.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	  %s   .
NICK_SET_NOEXPIRE_OFF
	  %s  .

# UNSET responses
NICK_UNSET_SYNTAX
	UNSET {URL | EMAIL | INFO}
NICK_UNSET_SYNTAX_REQ_EMAIL
	UNSET {URL | INFO}
NICK_UNSET_URL
	URL   %s .
NICK_UNSET_EMAIL
	E-mail    %s .
NICK_UNSET_INFO
	   %s .
NICK_UNSET_EMAIL_BAD
	     E-mail .
NICK_UNSET_EMAIL_OTHER_BAD
	E-mail      .

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} []
NICK_ACCESS_DISABLED
	,      .
NICK_ACCESS_ALREADY_PRESENT
	 %s      .
NICK_ACCESS_REACHED_LIMIT
	,     %d  .
NICK_ACCESS_NO_NICKS
	:       .     ,    user@host  .
NICK_ACCESS_ADDED
	%s     .
NICK_ACCESS_NOT_FOUND
	%s      .
NICK_ACCESS_DELETED
	%s     .
NICK_ACCESS_LIST_EMPTY
	   .
NICK_ACCESS_LIST
	 :
NICK_ACCESS_LIST_X_EMPTY
	  %s .
NICK_ACCESS_LIST_X
	  %s:

# LINK responses
NICK_OLD_LINK_SYNTAX
	LINK  
NICK_LINK_SYNTAX
	LINK 
NICK_LINK_DISABLED
	,    .
NICK_LINK_FAILED
	,   .
NICK_CANNOT_BE_LINKED
	 %s    .
NICK_OLD_LINK_SAME
	       !
NICK_LINK_SAME
	      !
NICK_LINK_ALREADY_LINKED
	 %s     .
NICK_LINK_IN_USE
	 %s  .
NICK_LINK_TOO_MANY
	      %d .
NICK_LINK_TOO_MANY_NICKS
	  %d   ( %d).    .
NICK_OLD_LINK_TOO_MANY_CHANNELS
	     %s:     (  %d).
NICK_OLD_LINKED
	      %s.
NICK_LINKED
	 %s    .

# UNLINK responses
NICK_OLD_UNLINK_SYNTAX
	UNLINK [ ]
NICK_UNLINK_SYNTAX
	UNLINK 
NICK_UNLINK_OPER_SYNTAX
	UNLINK  [FORCE]
NICK_UNLINK_DISABLED
	,    .
NICK_UNLINK_FAILED
	,    .
NICK_UNLINK_SAME
	       !
NICK_OLD_UNLINK_NOT_LINKED
	   .
NICK_UNLINK_NOT_LINKED_YOURS
	 %s     .
NICK_UNLINK_NOT_LINKED
	 %s  .
NICK_OLD_UNLINKED
	      %s.
NICK_UNLINKED
	   %s  .
NICK_X_UNLINKED
	   %s   %s.

# LISTLINKS responses
NICK_OLD_LISTLINKS_SYNTAX
	LISTLINKS 
NICK_LISTLINKS_SYNTAX
	LISTLINKS
NICK_LISTLINKS_HEADER
	 ,   %s:
NICK_LISTLINKS_FOOTER
	%d  .

# INFO responses
NICK_INFO_SYNTAX
	INFO  [ALL]
NICK_INFO_REALNAME
	%s  %s
NICK_INFO_ADDRESS
	 : %s
NICK_INFO_ADDRESS_ONLINE
	     : %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s  .
NICK_INFO_TIME_REGGED
	: %s
NICK_INFO_LAST_SEEN
	 : %s
NICK_INFO_LAST_QUIT
	 /QUIT: %s
NICK_INFO_URL
	            URL: %s
NICK_INFO_EMAIL
	   E-mail : %s
NICK_INFO_EMAIL_UNAUTHED
	   E-mail : %s ()
NICK_INFO_INFO
	     : %s
NICK_INFO_OPTIONS
	          : %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	
NICK_INFO_OPT_SECURE
	
NICK_INFO_OPT_PRIVATE
	
NICK_INFO_OPT_NONE
	
NICK_INFO_NO_EXPIRE
	   .
NICK_INFO_SUSPEND_DETAILS
	 %s  %s (%s).
NICK_INFO_SUSPEND_REASON
	        : %s
NICK_INFO_SHOW_ALL
	   : /msg %s INFO %s ALL

# LISTCHANS responses
NICK_LISTCHANS_SYNTAX
	LISTCHANS
NICK_LISTCHANS_NONE
	  %s     .
NICK_LISTCHANS_HEADER
	,   %s:
NICK_LISTCHANS_END
	  ( %d  ).

# LIST/LISTEMAIL responses
NICK_LIST_SYNTAX
	%s 
NICK_LIST_OPER_SYNTAX
	%s  [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
NICK_LIST_OPER_SYNTAX_AUTH
	%s  [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
NICK_LIST_HEADER
	   %s:
NICK_LIST_RESULTS
	 ; %d/%d  .
NICK_LISTEMAIL_NONE
	( )

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER  []
NICK_NO_RECOVER_SELF
	         !
NICK_RECOVERED
	,      .   /msg %s RELEASE %s        .

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE  []
NICK_RELEASE_NOT_HELD
	 %s  .
NICK_RELEASED
	     .

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST  []
NICK_NO_GHOST_SELF
	       !
NICK_GHOST_KILLED
	    .

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS 
NICK_GETPASS_UNAVAILABLE
	 GETPASS    , ..  .
NICK_GETPASS_PASSWORD_IS
	  %s: %s.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID 
NICK_FORBID_SUCCEEDED
	 %s    .
NICK_FORBID_FAILED
	    %s!

# SUSPEND responses
NICK_SUSPEND_SYNTAX
	SUSPEND [+_]  
NICK_SUSPEND_SUCCEEDED
	  %s       .
NICK_SUSPEND_ALREADY_SUSPENDED
	 %s  .

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND 
NICK_UNSUSPEND_SUCCEEDED
	  %s .
NICK_UNSUSPEND_NOT_SUSPENDED
	 %s   .

################ autojoin module messages/responses

# AJOIN responses
NICK_AJOIN_SYNTAX
	AJOIN {ADD | DEL | LIST} []
NICK_AJOIN_ADD_SYNTAX
	AJOIN ADD 
NICK_AJOIN_DEL_SYNTAX
	AJOIN DEL 
NICK_AJOIN_DISABLED
	,      .
NICK_AJOIN_ALREADY_PRESENT
	 %s      .
NICK_AJOIN_LIST_FULL
	,    %d     .
NICK_AJOIN_ADDED
	%s      .
NICK_AJOIN_NOT_FOUND
	%s       .
NICK_AJOIN_DELETED
	%s      .
NICK_AJOIN_LIST_EMPTY
	    .
NICK_AJOIN_LIST
	  :
NICK_AJOIN_LIST_X_EMPTY
	   %s .
NICK_AJOIN_LIST_X
	   %s:

################ mail-auth module messages/responses

# General-purpose messages
NICK_AUTH_SENT
	       : %s.
NICK_AUTH_FOR_REGISTER
	    ,  /msg %s AUTH code ( code    )     .
NICK_AUTH_FOR_SET_EMAIL
	    ,  /msg %s AUTH code ( code    )     E-mail .
	,           ,      .
NICK_AUTH_NOT_NEEDED
	 ,    .
NICK_AUTH_NO_AUTHCODE
	 %s    .
NICK_AUTH_HAS_AUTHCODE
	 %s    .
PASSWORD_WARNING_FOR_AUTH
	:         .

# Mail text.  The last "%s" (before the user@host) in the body text is
# replaced by one of the NICK_AUTH_MAIL_TEXT_* messages.
NICK_AUTH_MAIL_SUBJECT
	   %s
NICK_AUTH_MAIL_BODY
	    (%s): %09d
	,   %s  :
	    /msg %s AUTH %09d
	
	    %s    %s
	%s@%s.
NICK_AUTH_MAIL_TEXT_REG
	 
NICK_AUTH_MAIL_TEXT_EMAIL
	 E-mail  
NICK_AUTH_MAIL_TEXT_SENDAUTH
	 SENDAUTH 
NICK_AUTH_MAIL_BODY_SETAUTH
	     (%s): %09d
	,   %s  :
	    /msg %s AUTH %09d

# AUTH responses
NICK_AUTH_SYNTAX
	AUTH 
NICK_AUTH_DISABLED
	,    .
NICK_AUTH_FAILED
	  .
NICK_AUTH_SUCCEEDED_REGISTER
	  ;    .
NICK_AUTH_SUCCEEDED_SET_EMAIL
	  ;   E-mail  .
NICK_AUTH_SUCCEEDED_SETAUTH
	  ;      .

# SENDAUTH responses
NICK_SENDAUTH_SYNTAX
	SENDAUTH
NICK_SENDAUTH_TOO_SOON
	,  %s     SENDAUTH  .
NICK_SENDAUTH_FAILED
	,    .

# SETAUTH responses
NICK_SETAUTH_SYNTAX
	SETAUTH 
NICK_SETAUTH_NO_EMAIL
	  E-mail    %s.
NICK_SETAUTH_AUTHCODE_SET
	   (%09d)    %s.
NICK_SETAUTH_SEND_FAILED
	:     %s.
NICK_SETAUTH_SEND_TEMPFAIL
	:     %s ( ).
NICK_SETAUTH_USER_NOTICE
	         .        E-mail : %s
	 /msg %s HELP AUTH   .

# GETAUTH responses
NICK_GETAUTH_SYNTAX
	GETAUTH 
NICK_GETAUTH_AUTHCODE_IS
	    %s: %09d

# CLEARAUTH responses
NICK_CLEARAUTH_SYNTAX
	CLEARAUTH 
NICK_CLEARAUTH_CLEARED
	    %s .

################ sendpass module messages/responses

# Mail text
NICK_SENDPASS_MAIL_SUBJECT
	  %s
NICK_SENDPASS_MAIL_BODY
	   : %s
	
	   %s    SENDPASS  
	%s@%s.

# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS 
NICK_SENDPASS_FAILED
	,    .
NICK_SENDPASS_NO_EMAIL
	  E-mail    %s.
NICK_SENDPASS_NOT_AUTHED
	E-mail    %s   .
# parameter is "NNN days/hours/minutes"
NICK_SENDPASS_TOO_SOON
	,  %s     SENDPASS  .
NICK_SENDPASS_SENT
	   %s    E-mail .

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	 
CHAN_LEVEL_AUTOVOICE
	  (+v)
CHAN_LEVEL_INVITE
	   INVITE
CHAN_LEVEL_AKICK
	   AKICK
CHAN_LEVEL_SET
	   SET (  FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	   CLEAR
CHAN_LEVEL_UNBAN
	   UNBAN
CHAN_LEVEL_OPDEOP
	   OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	   
CHAN_LEVEL_ACCESS_CHANGE
	   
CHAN_LEVEL_MEMO
	 /  
CHAN_LEVEL_VOICE
	   VOICE/DEVOICE
CHAN_LEVEL_AUTOHALFOP
	  (+h)
CHAN_LEVEL_HALFOP
	   HALFOP/DEHALFOP
CHAN_LEVEL_AUTOPROTECT
	   (+a)
CHAN_LEVEL_PROTECT
	   PROTECT/DEPROTECT
CHAN_LEVEL_KICK
	   KICK
CHAN_LEVEL_STATUS
	   STATUS
CHAN_LEVEL_TOPIC
	   TOPIC

# Automatic responses
CHAN_IS_REGISTERED
	   %s
CHAN_MAY_NOT_BE_USED
	    .
CHAN_NOT_ALLOWED_TO_JOIN
	       .

# Multi-purpose responses
CHAN_MUST_IDENTIFY_NICK
	,    %s,  :
	/msg %s IDENTIFY 
CHAN_BOUNCY_MODES
	,   %s  .

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER   
CHAN_REGISTER_DISABLED
	,    .
CHAN_REGISTER_SHORT_CHANNEL
	 #    .
CHAN_REGISTER_NOT_LOCAL
	     .
CHAN_REGISTER_INVALID_NAME
	     ,    #.
CHAN_MUST_REGISTER_NICK
	     .  /msg %s HELP      .
CHAN_MAY_NOT_BE_REGISTERED
	 %s    .
CHAN_ALREADY_REGISTERED
	 %s  !
CHAN_MUST_BE_CHANOP
	    ,   .
CHAN_REACHED_CHANNEL_LIMIT
	,      %d .
CHAN_EXCEEDED_CHANNEL_LIMIT
	,      %d .
CHAN_REGISTRATION_FAILED
	,   .
CHAN_REGISTERED
	 %s    : %s
CHAN_PASSWORD_IS
	    %s --     .

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY  
CHAN_IDENTIFY_FAILED
	,   .
CHAN_IDENTIFY_SUCCEEDED
	  -       %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP 
CHAN_DROP_DISABLED
	,    .
CHAN_DROPPED
	 %s .

# SET responses
CHAN_SET_SYNTAX
	SET   
CHAN_SET_DISABLED
	,     .
CHAN_SET_UNKNOWN_OPTION
	 SET  %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s     .
CHAN_FOUNDER_CHANGED
	  %s   %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	  %s   %s.
CHAN_SUCCESSOR_IS_FOUNDER
	       .

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	,   .
CHAN_PASSWORD_CHANGED
	%s  .
CHAN_PASSWORD_CHANGED_TO
	%s    %s.

# SET DESC responses
CHAN_DESC_CHANGED
	  %s   %s.

# SET URL responses
CHAN_URL_CHANGED
	URL  %s   %s.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	E-mail   %s   %s.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	    %s .

# SET MLOCK responses
CHAN_SET_MLOCK_NEED_PLUS_MINUS
	      + ()  - ().
CHAN_SET_MLOCK_NEED_PARAM
	    MLOCK +%c.
CHAN_SET_MLOCK_NEED_POSITIVE
	   MLOCK +%c    .
CHAN_SET_MLOCK_MODE_REG_BAD
	 +%c            MLOCK.
CHAN_SET_MLOCK_LINK_BAD
	   MLOCK +%c     .
CHAN_SET_MLOCK_LINK_SAME
	   MLOCK +%c    .
CHAN_SET_MLOCK_REQUIRES
	 MLOCK +%c  ,     MLOCK +%c.
CHAN_SET_MLOCK_BAD_PARAM
	    MLOCK +%c.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	   %c, .
CHAN_SET_MLOCK_CANNOT_LOCK
	 %c    .
CHAN_MLOCK_CHANGED
	    %s   %s.
CHAN_MLOCK_REMOVED
	    %s .

# SET HIDE responses
CHAN_SET_HIDE_SYNTAX
	SET  HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
CHAN_SET_HIDE_EMAIL_ON
	E-mail   %s      %s INFO.
CHAN_SET_HIDE_EMAIL_OFF
	E-mail   %s    %s INFO.
CHAN_SET_HIDE_TOPIC_ON
	  %s      %s INFO.
CHAN_SET_HIDE_TOPIC_OFF
	  %s    %s INFO.
CHAN_SET_HIDE_MLOCK_ON
	   %s      %s INFO.
CHAN_SET_HIDE_MLOCK_OFF
	   %s    %s INFO.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET  KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	  .
CHAN_SET_KEEPTOPIC_OFF
	  .

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET  TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	  .
CHAN_SET_TOPICLOCK_OFF
	  .

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET  PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	 .
CHAN_SET_PRIVATE_OFF
	 .

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET  SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	   .
CHAN_SET_SECUREOPS_OFF
	   .

# SET LEAVEOPS responses
CHAN_SET_LEAVEOPS_SYNTAX
	SET  LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	     .
CHAN_SET_LEAVEOPS_OFF
	     .

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET  RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	  .
CHAN_SET_RESTRICTED_OFF
	  .

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET  SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	 .
CHAN_SET_SECURE_OFF
	 .

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET  OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	  OP/DEOP .
CHAN_SET_OPNOTICE_OFF
	  OP/DEOP .

# SET ENFORCE responses
CHAN_SET_ENFORCE_SYNTAX
	SET  ENFORCE {ON | OFF}
CHAN_SET_ENFORCE_ON
	   .
CHAN_SET_ENFORCE_OFF
	   .

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET  NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	  %s   .
CHAN_SET_NOEXPIRE_OFF
	  %s  .

# UNSET responses
CHAN_UNSET_SYNTAX
	UNSET  {SUCCESSOR | URL | EMAIL | ENTRYMSG}
CHAN_SUCCESSOR_UNSET
	   %s .
CHAN_URL_UNSET
	URL   %s .
CHAN_EMAIL_UNSET
	E-mail    %s .
CHAN_ENTRY_MSG_UNSET
	    %s .

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS  {ADD | DEL | LIST | COUNT} [ [] |  ]
CHAN_ACCESS_DISABLED
	,      .
CHAN_ACCESS_LEVEL_NONZERO
	     .
CHAN_ACCESS_LEVEL_RANGE
	     %d  %d .
CHAN_ACCESS_NICKS_ONLY
	       .
CHAN_ACCESS_REACHED_LIMIT
	,     %d    .
CHAN_ACCESS_LEVEL_UNCHANGED
	  %s  %s    %d.
CHAN_ACCESS_LEVEL_CHANGED
	  %s  %s   %d.
CHAN_ACCESS_ADDED
	%s ()    %s   %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	   (#%d)    %s.
CHAN_ACCESS_NOT_FOUND
	%s      %s.
CHAN_ACCESS_NO_MATCH
	      %s.
CHAN_ACCESS_DELETED
	%s ()    %s.
CHAN_ACCESS_DELETED_ONE
	 1     %s.
CHAN_ACCESS_DELETED_SEVERAL
	 %d     %s.
CHAN_ACCESS_LIST_EMPTY
	  %s .
CHAN_ACCESS_LIST_HEADER
	  %s:
	       
CHAN_ACCESS_LIST_FORMAT
	 %4d  %4d  %s
CHAN_ACCESS_COUNT
	  %s  %d .

# XOP (AOP/SOP/VOP) responses
CHAN_SOP_SYNTAX
	SOP  {ADD | DEL | LIST | COUNT} [ |  ]
CHAN_AOP_SYNTAX
	AOP  {ADD | DEL | LIST | COUNT} [ |  ]
CHAN_HOP_SYNTAX
	HOP  {ADD | DEL | LIST | COUNT} [ |  ]
CHAN_VOP_SYNTAX
	VOP  {ADD | DEL | LIST | COUNT} [ |  ]
CHAN_XOP_ADDED
	%s   %s %s .
CHAN_XOP_LEVEL_CHANGED
	%s   %s %s .
CHAN_XOP_LEVEL_UNCHANGED
	%s   %s %s .
CHAN_XOP_NICKS_ONLY
	SOP, AOP,  VOP      .
CHAN_XOP_NICKS_ONLY_HOP
	SOP, AOP, HOP,  VOP      .
CHAN_XOP_REACHED_LIMIT
	,     SOP, AOP  VOP 
	     %d .   .
CHAN_XOP_REACHED_LIMIT_HOP
	,     SOP, AOP, HOP  VOP 
	     %d .   .
CHAN_XOP_NOT_FOUND
	%s    %s %s .
CHAN_XOP_NO_SUCH_ENTRY
	   (#%d)  %s %s .
CHAN_XOP_NO_MATCH
	    %s %s .
CHAN_XOP_DELETED
	%s   %s %s .
CHAN_XOP_DELETED_ONE
	 1   %s %s .
CHAN_XOP_DELETED_SEVERAL
	 %d   %s %s .
CHAN_XOP_LIST_EMPTY
	%s %s   .
CHAN_XOP_LIST_HEADER
	%s  %s:
	     
CHAN_XOP_LIST_FORMAT
	 %4d   %s
CHAN_XOP_COUNT
	%s %s   %d .

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK  {ADD | DEL | LIST | VIEW | ENFORCE | COUNT} [ | ]
CHAN_AKICK_DISABLED
	,  autokick   .
CHAN_AKICK_ALREADY_EXISTS
	%s    %s autokick .
CHAN_AKICK_REACHED_LIMIT
	,     %d autokick   .
CHAN_AKICK_ADDED
	%s   %s autokick .
CHAN_AKICK_NO_SUCH_ENTRY
	   (#%d)  %s autokick .
CHAN_AKICK_NOT_FOUND
	%s    %s autokick .
CHAN_AKICK_NO_MATCH
	    %s autokick .
CHAN_AKICK_DELETED
	%s   %s autokick .
CHAN_AKICK_DELETED_ONE
	 1   %s autokick .
CHAN_AKICK_DELETED_SEVERAL
	 %d   %s autokick .
CHAN_AKICK_LIST_EMPTY
	%s autokick  .
CHAN_AKICK_LIST_HEADER
	Autokick   %s:
# index, mask, set-by, set-time, last-used, reason
CHAN_AKICK_VIEW_FORMAT
	  %3d %s ( %s  %s;   %s)
	         %s
# index, mask, set-by, set-time, reason
CHAN_AKICK_VIEW_UNUSED_FORMAT
	  %3d %s ( %s  %s;   )
	         %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE  %s ; %d  .
CHAN_AKICK_COUNT
	%s  %d   AKICK .

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS  {SET | DIS[ABLE] | LIST | RESET} [ []]
CHAN_LEVELS_READONLY
	,      .
CHAN_LEVELS_RANGE
	    %d  %d .
CHAN_LEVELS_CHANGED
	  %s   %s   %d.
CHAN_LEVELS_UNKNOWN
	 %s .  /msg %s HELP LEVELS DESC     .
CHAN_LEVELS_DISABLED
	%s    %s.
CHAN_LEVELS_LIST_HEADER
	   %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  ()
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  ( )
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %4d
CHAN_LEVELS_RESET
	  %s   .

# INFO responses
CHAN_INFO_SYNTAX
	INFO  [ALL]
CHAN_INFO_HEADER
	   %s:
CHAN_INFO_FOUNDER
	           : %s
CHAN_INFO_SUCCESSOR
	           : %s
CHAN_INFO_DESCRIPTION
	           : %s
CHAN_INFO_ENTRYMSG
	  : %s
CHAN_INFO_TIME_REGGED
	    : %s
CHAN_INFO_LAST_USED
	        : %s
CHAN_INFO_LAST_TOPIC
	     : %s
CHAN_INFO_TOPIC_SET_BY
	    : %s
CHAN_INFO_URL
	                URL: %s
CHAN_INFO_EMAIL
	       E-mail : %s
CHAN_INFO_OPTIONS
	              : %s
CHAN_INFO_OPT_PRIVATE
	
CHAN_INFO_OPT_KEEPTOPIC
	 
CHAN_INFO_OPT_TOPICLOCK
	 
CHAN_INFO_OPT_SECUREOPS
	  
CHAN_INFO_OPT_LEAVEOPS
	    
CHAN_INFO_OPT_RESTRICTED
	 
CHAN_INFO_OPT_SECURE
	
CHAN_INFO_OPT_OPNOTICE
	  OP/DEOP
CHAN_INFO_OPT_ENFORCE
	  
CHAN_INFO_OPT_NONE
	
CHAN_INFO_MODE_LOCK
	 : %s
CHAN_INFO_NO_EXPIRE
	   .
CHAN_INFO_SUSPEND_DETAILS
	 %s  %s (%s).
CHAN_INFO_SUSPEND_REASON
	          : %s
CHAN_INFO_SHOW_ALL
	   : /msg %s INFO %s ALL

# LIST responses
CHAN_LIST_SYNTAX
	LIST 
CHAN_LIST_OPER_SYNTAX
	LIST  [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
CHAN_LIST_HEADER
	 ,  %s:
CHAN_LIST_END
	 ; %d/%d  .

# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE 
CHAN_INVITE_OK
	 %s   %s.

# OP/DEOP/VOICE/DEVOICE responses
CHAN_OPVOICE_SYNTAX
	%s  []
CHAN_OP_SUCCEEDED
	%s ()     %s.
CHAN_OP_ALREADY
	%s     %s.
CHAN_OP_FAILED
	     %s   %s.
CHAN_DEOP_SUCCEEDED
	 %s      %s.
CHAN_DEOP_ALREADY
	%s     %s.
CHAN_DEOP_FAILED
	     %s   %s.
CHAN_VOICE_SUCCEEDED
	%s ()     %s.
CHAN_VOICE_ALREADY
	%s       %s.
CHAN_VOICE_FAILED
	     %s   %s.
CHAN_DEVOICE_SUCCEEDED
	 %s      %s.
CHAN_DEVOICE_ALREADY
	%s       %s.
CHAN_DEVOICE_FAILED
	     %s   %s.
CHAN_HALFOP_SUCCEEDED
	%s ()     %s.
CHAN_HALFOP_ALREADY
	%s       %s.
CHAN_HALFOP_FAILED
	     %s   %s.
CHAN_DEHALFOP_SUCCEEDED
	 %s      %s.
CHAN_DEHALFOP_ALREADY
	%s       %s.
CHAN_DEHALFOP_FAILED
	     %s   %s.
CHAN_PROTECT_SUCCEEDED
	   %s   %s.
CHAN_PROTECT_ALREADY
	%s  ()   %s.
CHAN_PROTECT_FAILED
	    %s   %s.
CHAN_DEPROTECT_SUCCEEDED
	 %s     %s.
CHAN_DEPROTECT_ALREADY
	%s      %s.
CHAN_DEPROTECT_FAILED
	    %s   %s.

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN 
CHAN_UNBANNED
	      %s.

# KICK responses
CHAN_KICK_SYNTAX
	KICK   []
CHAN_KICK_PROTECTED
	%s    ()   %s.
CHAN_KICKED
	%s ()   %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC  

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR  
CHAN_CLEARED_BANS
	    %s .
CHAN_CLEARED_EXCEPTIONS
	      %s .
CHAN_CLEARED_INVITES
	     %s .
CHAN_CLEARED_MODES
	    %s .
CHAN_CLEARED_OPS
	 +o    %s.
CHAN_CLEARED_HALFOPS
	 +h    %s.
CHAN_CLEARED_VOICES
	 +v    %s.
CHAN_CLEARED_USERS
	     %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS 
CHAN_GETPASS_UNAVAILABLE
	 GETPASS , ..  .
CHAN_GETPASS_PASSWORD_IS
	   %s: %s.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID 
CHAN_FORBID_SHORT_CHANNEL
	 #    .
CHAN_FORBID_SUCCEEDED
	 %s   .
CHAN_FORBID_FAILED
	    %s!

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND [+_]  
CHAN_SUSPEND_SUCCEEDED
	 %s .
CHAN_SUSPEND_ALREADY_SUSPENDED
	 %s  .

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND 
CHAN_UNSUSPEND_SUCCEEDED
	  %s .
CHAN_UNSUSPEND_NOT_SUSPENDED
	 %s   .

################ sendpass module messages/responses

# Mail text
CHAN_SENDPASS_MAIL_SUBJECT
	  %s
CHAN_SENDPASS_MAIL_BODY
	   %s: %s
	
	    %s    SENDPASS  
	%s@%s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS 
CHAN_SENDPASS_FAILED
	,    .
CHAN_SENDPASS_FOUNDER_ONLY
	       SENDPASS.
CHAN_SENDPASS_NO_EMAIL
	    E-mail    .
# parameter is "NNN days/hours/minutes"
CHAN_SENDPASS_TOO_SOON
	,  %s     SENDPASS  .
CHAN_SENDPASS_SENT
	  %s   %s.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	    .
MEMO_HAVE_NEW_MEMOS
	  %d  .
MEMO_TYPE_READ_LAST
	 /msg %s READ LAST  .
MEMO_TYPE_READ_NUM
	 /msg %s READ %d  .
MEMO_TYPE_LIST_NEW
	 /msg %s LIST NEW   .
MEMO_AT_LIMIT
	:     (%d).      ,         .
MEMO_OVER_LIMIT
	:     (%d).      ,         .
MEMO_NEW_MEMO_ARRIVED
	     %s.
	 /msg %s READ %d   .

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	   .
MEMO_X_HAS_NO_MEMOS
	%s   .
MEMO_DOES_NOT_EXIST
	 %d  !
MEMO_LIST_NOT_FOUND
	   .

# SEND responses
MEMO_SEND_SYNTAX
	SEND { | }  
MEMO_SEND_DISABLED
	,    .
MEMO_SEND_PLEASE_WAIT
	,  %s     SEND  .
MEMO_X_GETS_NO_MEMOS
	%s    .
MEMO_X_HAS_TOO_MANY_MEMOS
	 %s      ()    .
MEMO_SENT
	   %s.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [] [ |  | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	    .
MEMO_X_HAS_NO_NEW_MEMOS
	 %s   .
MEMO_LIST_MEMOS
	  %s.   , : /msg %s READ 
MEMO_LIST_NEW_MEMOS
	   %s.   , : /msg %s READ 
MEMO_LIST_CHAN_MEMOS
	  %s.   , : /msg %s READ %s 
MEMO_LIST_CHAN_NEW_MEMOS
	   %s.   , : /msg %s READ %s 
MEMO_LIST_HEADER
	                /
MEMO_LIST_FORMAT
	%c%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [] { |  | LAST | NEW}
MEMO_HEADER
	 %d  %s (%s).  , : /msg %s DEL %d
MEMO_CHAN_HEADER
	 %d  %s (%s).  , : /msg %s DEL %s %d

# SAVE responses
MEMO_SAVE_SYNTAX
	SAVE [] { |}
MEMO_SAVED_ONE
	 %d  .
MEMO_SAVED_SEVERAL
	%d  .

# DEL responses
MEMO_DEL_SYNTAX
	DEL [] { |  | ALL}
MEMO_DELETED_NONE
	    .
MEMO_DELETED_ONE
	 %d .
MEMO_DELETED_SEVERAL
	%d  .
MEMO_DELETED_ALL
	   .

# SET responses
MEMO_SET_SYNTAX
	SET  
MEMO_SET_DISABLED
	,     .
MEMO_SET_UNKNOWN_OPTION
	 SET  %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s          ,      .
MEMO_SET_NOTIFY_LOGON
	%s              /AWAY.
MEMO_SET_NOTIFY_NEW
	%s         .
MEMO_SET_NOTIFY_OFF
	%s       .

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [] 
MEMO_SET_LIMIT_OPER_SYNTAX
	SET LIMIT [ | ] { | NONE | DEFAULT} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	       .
MEMO_SET_LIMIT_FORBIDDEN
	   %s    .
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	         %d.
MEMO_SET_LIMIT_TOO_HIGH
	      %s   %d.
MEMO_SET_LIMIT_OVERFLOW
	   ;   %d.
MEMO_SET_YOUR_LIMIT
	     %d.
MEMO_SET_YOUR_LIMIT_ZERO
	     .
MEMO_SET_YOUR_LIMIT_DEFAULT
	     (%d).
MEMO_UNSET_YOUR_LIMIT
	     .
MEMO_SET_LIMIT
	   %s   %d.
MEMO_SET_LIMIT_ZERO
	   %s   0.
MEMO_SET_LIMIT_DEFAULT
	   %s    (%d).
MEMO_UNSET_LIMIT
	 %s    .

# INFO responses
MEMO_INFO_NO_MEMOS
	   .
MEMO_INFO_MEMO
	  1 .
MEMO_INFO_MEMO_UNREAD
	  1       .
MEMO_INFO_MEMOS
	  %d .
MEMO_INFO_MEMOS_ONE_UNREAD
	  %d ,   1 .
MEMO_INFO_MEMOS_SOME_UNREAD
	  %d ,      %d.
MEMO_INFO_MEMOS_ALL_UNREAD
	  %d ;      .
MEMO_INFO_LIMIT
	  : %d.
MEMO_INFO_HARD_LIMIT
	   %d,     .
MEMO_INFO_LIMIT_ZERO
	   0;        .
MEMO_INFO_HARD_LIMIT_ZERO
	   0;        .     .
MEMO_INFO_NO_LIMIT
	    ,    .
MEMO_INFO_NOTIFY_OFF
	      .
MEMO_INFO_NOTIFY_ON
	           .
MEMO_INFO_NOTIFY_RECEIVE
	        .
MEMO_INFO_NOTIFY_SIGNON
	         IRC.
MEMO_INFO_X_NO_MEMOS
	%s   .
MEMO_INFO_X_MEMO
	%s  1 .
MEMO_INFO_X_MEMO_UNREAD
	%s  1      .
MEMO_INFO_X_MEMOS
	%s  %d .
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s  %d ,   1 .
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s  %d ,   %d .
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s  %d ;    .
MEMO_INFO_X_LIMIT
	   %s: %d.
MEMO_INFO_X_HARD_LIMIT
	   %s %d     .
MEMO_INFO_X_NO_LIMIT
	%s    .
MEMO_INFO_X_NOTIFY_OFF
	%s     .
MEMO_INFO_X_NOTIFY_ON
	%s           .
MEMO_INFO_X_NOTIFY_RECEIVE
	%s        .
MEMO_INFO_X_NOTIFY_SIGNON
	%s       .

################ forward module messages/responses

# Mail format
MEMO_FORWARD_MAIL_SUBJECT
	  %s
MEMO_FORWARD_MAIL_BODY
	  %s (%s)
	%s

# FORWARD responses
MEMO_FORWARD_SYNTAX
	FORWARD { |  | ALL}
MEMO_FORWARD_NEED_EMAIL
	   E-mail   ,     .
MEMO_FORWARD_PLEASE_WAIT
	  %s     FORWARD  .
MEMO_FORWARD_FAILED
	,   .
MEMO_FORWARDED_NONE
	     .
MEMO_FORWARDED_ONE
	 %d .
MEMO_FORWARDED_SEVERAL
	%d  .
MEMO_FORWARDED_ALL
	   .
MEMO_FORWARDED_ALSO_TEMPFAIL
	:      , ..   .
MEMO_FORWARDED_ALSO_PERMFAIL
	:       -  .

# SET FORWARD responses
MEMO_SET_FORWARD_SYNTAX
	SET FORWARD {ON | COPY | OFF}
MEMO_SET_FORWARD_ON
	      E-mail : %s
MEMO_SET_FORWARD_COPY
	      E-mail : %s
	     .
MEMO_SET_FORWARD_OFF
	       E-mail .

################ ignore module messages/responses

# IGNORE responses
MEMO_IGNORE_SYNTAX
	IGNORE {ADD | DEL | LIST} [ | ]
MEMO_IGNORE_ADD_SYNTAX
	IGNORE ADD  | 
MEMO_IGNORE_DEL_SYNTAX
	IGNORE DEL  | 
MEMO_IGNORE_LIST_FULL
	   .
MEMO_IGNORE_ALREADY_PRESENT
	%s    .
MEMO_IGNORE_ADDED
	%s     .
MEMO_IGNORE_NOT_FOUND
	%s      .
MEMO_IGNORE_DELETED
	%s     .
MEMO_IGNORE_LIST_EMPTY
	   .
MEMO_IGNORE_LIST
	 :
MEMO_IGNORE_LIST_X_EMPTY
	   %s .
MEMO_IGNORE_LIST_X
	   %s:

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	    .    ?
OPER_BOUNCY_MODES_U_LINE
	    . U:lines    ?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL 

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	 STATS  %s.
OPER_STATS_RESET_USER_COUNT
	    .

OPER_STATS_CURRENT_USERS
	 : %d (%d )
OPER_STATS_MAX_USERS
	 : %d (%s)
# Parameters: days, STR_DAYS or STR_DAY, hours, minutes, seconds
OPER_STATS_UPTIME_DHMS
	   %d%s, %02d:%02d
# If >= 1 hour, hours and minutes; if < 1 hour, minutes and seconds
OPER_STATS_UPTIME_HM_MS
	   %s

OPER_STATS_KBYTES_READ
	           : %10u kB
OPER_STATS_KBYTES_WRITTEN
	          : %10u kB
OPER_STATS_NETBUF_SOCK
	  : %5u kB
OPER_STATS_NETBUF_SOCK_PERCENT
	  : %5u kB (%d%%)
OPER_STATS_NETBUF_TOTAL
	     : %5u kB
OPER_STATS_NETBUF_TOTAL_PERCENT
	     : %5u kB (%d%%)

OPER_STATS_ALL_USER_MEM
	             : %6d , %5d kB
OPER_STATS_ALL_CHANNEL_MEM
	                 : %6d , %5d kB
OPER_STATS_ALL_SERVER_MEM
	                : %6d , %5d kB
OPER_STATS_ALL_NICKGROUPINFO_MEM
	              : %6d , %5d kB
OPER_STATS_ALL_NICKINFO_MEM
	                   : %6d , %5d kB
OPER_STATS_ALL_CHANSERV_MEM
	                ChanServ: %6d , %5d kB
OPER_STATS_ALL_STATSERV_MEM
	                StatServ: %6d , %5d kB
OPER_STATS_ALL_NEWS_MEM
	                    News: %6d , %5d kB
OPER_STATS_ALL_AKILL_MEM
	               Autokills: %6d , %5d kB
OPER_STATS_ALL_EXCEPTION_MEM
	              : %6d , %5d kB
OPER_STATS_ALL_SGLINE_MEM
	                 SGlines: %6d , %5d kB
OPER_STATS_ALL_SQLINE_MEM
	                 SQlines: %6d , %5d kB
OPER_STATS_ALL_SZLINE_MEM
	                 SZlines: %6d , %5d kB
OPER_STATS_ALL_SESSION_MEM
	                  : %6d , %5d kB

# MODE responses
OPER_MODE_SYNTAX
	MODE  

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES  [ALL]
OPER_CLEARMODES_DONE
	      %s.
OPER_CLEARMODES_EXCEPT_DONE
	,         %s.
OPER_CLEARMODES_ALL_DONE
	     %s.

# CLEARCHAN responses
OPER_CLEARCHAN_SYNTAX
	CLEARCHAN 
OPER_CLEARCHAN_DONE
	     %s.

# KICK responses
OPER_KICK_SYNTAX
	KICK   

# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} []
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD 
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL 
OPER_ADMIN_NO_NICKSERV
	NickServ ;  ADMIN .
OPER_ADMIN_EXISTS
	%s     .
OPER_ADMIN_ADDED
	%s     .
OPER_ADMIN_TOO_MANY
	   (%d)    ;   .
OPER_ADMIN_REMOVED
	%s     .
OPER_ADMIN_NOT_FOUND
	%s      .
OPER_ADMIN_LIST_HEADER
	  :

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD | DEL | LIST} []
OPER_OPER_ADD_SYNTAX
	OPER ADD 
OPER_OPER_DEL_SYNTAX
	OPER DEL 
OPER_OPER_NO_NICKSERV
	NickServ ;  OPER .
OPER_OPER_EXISTS
	%s     .
OPER_OPER_ADDED
	%s     .
OPER_OPER_TOO_MANY
	   (%d)    ;   .
OPER_OPER_REMOVED
	%s     .
OPER_OPER_NOT_FOUND
	%s      .
OPER_OPER_LIST_HEADER
	  :

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | COUNT} [[+_]  []]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+_]  
OPER_AKILL_DEL_SYNTAX
	AKILL DEL 
OPER_TOO_MANY_AKILLS
	Autokill  !
OPER_AKILL_EXISTS
	%s   autokill .
OPER_AKILL_NO_NICK
	: Autokill     ; ,       .
OPER_AKILL_MASK_TOO_GENERAL
	Autokill   .
OPER_AKILL_EXPIRY_LIMITED
	    ,  %s.
OPER_AKILL_ADDED
	%s   autokill .
OPER_AKILL_REMOVED
	%s   autokill .
OPER_AKILL_NOT_FOUND
	%s    autokill .
OPER_AKILL_LIST_HEADER
	Autokill :
# mask, reason
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_AKILL_VIEW_FORMAT
	%s ( %s  %s,   %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_UNUSED_FORMAT
	%s ( %s  %s,   ; %s)
	    %s
OPER_AKILL_COUNT
	Autokill   %d .

# AKILLCHAN responses
OPER_AKILLCHAN_SYNTAX
	AKILLCHAN [KILL] [+_]  
OPER_AKILLCHAN_AKILLED
	%d     autokill.
OPER_AKILLCHAN_KILLED
	%d  .
OPER_AKILLCHAN_AKILLED_ONE
	1     autokill.
OPER_AKILLCHAN_KILLED_ONE
	1  .

# EXCLUDE responses
OPER_EXCLUDE_SYNTAX
	EXCLUDE {ADD | DEL | LIST | VIEW | COUNT} [[+_]  []]
OPER_EXCLUDE_ADD_SYNTAX
	EXCLUDE ADD [+_]  
OPER_EXCLUDE_DEL_SYNTAX
	EXCLUDE DEL 
OPER_TOO_MANY_EXCLUDES
	EXCLUDE  !
OPER_EXCLUDE_EXISTS
	%s     autokill .
OPER_EXCLUDE_ADDED
	%s    autokill .
OPER_EXCLUDE_REMOVED
	%s    autokill .
OPER_EXCLUDE_NOT_FOUND
	%s     autokill .
OPER_EXCLUDE_LIST_HEADER
	 autokill :
# mask, reason
OPER_EXCLUDE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_EXCLUDE_VIEW_FORMAT
	%s ( %s  %s,   %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_EXCLUDE_VIEW_UNUSED_FORMAT
	%s ( %s  %s,   ; %s)
	    %s
OPER_EXCLUDE_COUNT
	 autokill   %d .

# SxLINE responses
OPER_SLINE_SYNTAX
	%s {ADD | DEL | LIST | VIEW | COUNT} [[+_]  []]
OPER_SLINE_ADD_SYNTAX
	%s ADD [+_]  
OPER_SLINE_DEL_SYNTAX
	%s DEL 
OPER_TOO_MANY_SLINES
	%s  !
OPER_SLINE_EXISTS
	%s   %s .
OPER_SLINE_MASK_TOO_GENERAL
	 %s  .
OPER_SLINE_ADDED
	%s   %s .
OPER_SLINE_REMOVED
	%s   %s .
OPER_SLINE_NOT_FOUND
	%s    %s .
OPER_SLINE_LIST_HEADER
	%s :
# mask, reason
OPER_SLINE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_SLINE_VIEW_FORMAT
	%s ( %s  %s,   %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_SLINE_VIEW_UNUSED_FORMAT
	%s ( %s  %s,   ; %s)
	    %s
OPER_SLINE_COUNT
	%d   %s .
OPER_SZLINE_NOT_AVAIL
	SZLINE    IRC .

# SU responses
OPER_SU_SYNTAX
	SU 
OPER_SU_NO_PASSWORD
	 SU , ..    .
OPER_SU_SUCCEEDED
	      .
OPER_SU_FAILED
	  .

# SET responses
OPER_SET_SYNTAX
	SET  
OPER_SET_IGNORE_ON
	   .
OPER_SET_IGNORE_OFF
	    .
OPER_SET_IGNORE_ERROR
	 IGNORE     ON  OFF.
OPER_SET_READONLY_ON
	     .
OPER_SET_READONLY_OFF
	    -.
OPER_SET_READONLY_ERROR
	 READONLY     ON  OFF.
OPER_SET_DEBUG_ON
	    .
OPER_SET_DEBUG_OFF
	      .
OPER_SET_DEBUG_LEVEL
	     ( %d).
OPER_SET_DEBUG_ERROR
	 DEBUG     ON, OFF,   .
OPER_SET_SUPASS_FAILED
	     .
OPER_SET_SUPASS_OK
	    .
OPER_SET_SUPASS_NONE
	    .
OPER_SET_UNKNOWN_OPTION
	  %s.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE  []
OPER_JUPE_INVALID_NAME
	   (    ).
OPER_JUPE_ALREADY_JUPED
	 %s   .

# RAW responses
OPER_RAW_SYNTAX
	RAW 

# UPDATE responses
OPER_UPDATE_SYNTAX
	UPDATE [FORCE]
OPER_UPDATE_FORCE_FAILED
	  .
OPER_UPDATING
	 ...
OPER_UPDATE_COMPLETE
	   .
OPER_UPDATE_FAILED
	   .

# REHASH responses
OPER_REHASHING
	  .
OPER_REHASHED
	    .
OPER_REHASH_ERROR
	      . ,       .

# LISTIGNORE responses
OPER_IGNORE_LIST
	  :
OPER_IGNORE_LIST_EMPTY
	  .

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES 
OPER_KILLCLONES_UNKNOWN_NICK
	    %s.
OPER_KILLCLONES_KILLED
	%s   KILLCLONES  %s  %d .
OPER_KILLCLONES_KILLED_AKILL
	%s   KILLCLONES  %s  %d .    AKILL  %s.


###########################################################################
#
# Session limiting and exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} []
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+_]   
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL { | }
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE  _
OPER_EXCEPTION_ALREADY_PRESENT
	 %s     .
OPER_EXCEPTION_TOO_MANY
	    !
OPER_EXCEPTION_ADDED
	   %s   %d.
OPER_EXCEPTION_MOVED
	  %s (#%d)    %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	   (#%d)     .
OPER_EXCEPTION_NOT_FOUND
	%s       .
OPER_EXCEPTION_NO_MATCH
	       .
OPER_EXCEPTION_EMPTY
	    .
OPER_EXCEPTION_DELETED
	%s      .
OPER_EXCEPTION_DELETED_ONE
	 1      .
OPER_EXCEPTION_DELETED_SEVERAL
	 %d      .
OPER_EXCEPTION_LIST_HEADER
	    :
# number, limit, host
OPER_EXCEPTION_LIST_COLHEAD
	    
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
# number, mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  ( %s  %s; %s)
	    : %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	  ;           %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	 .        ,        .

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST  | VIEW }
OPER_SESSION_LIST_SYNTAX
	SESSION LIST 
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW 
OPER_SESSION_INVALID_THRESHOLD
	  .       1.
OPER_SESSION_NOT_FOUND
	%s     .
OPER_SESSION_LIST_HEADER
	    %d  :
OPER_SESSION_LIST_COLHEAD
	  
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	 %s   %d  %d  .


###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[ - %s] %s
NEWS_OPER_TEXT
	[   - %s] %s

NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD | DEL | LIST} [ | ]
NEWS_LOGON_LIST_HEADER
	 :
NEWS_LOGON_LIST_ENTRY
	%5d (%s  %s)
	    %s
NEWS_LOGON_LIST_NONE
	 .
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD 
NEWS_LOGON_ADD_FULL
	  !
NEWS_LOGON_ADDED
	   (#%d).
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL { | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	   #%d  !
NEWS_LOGON_DELETED
	   #%d .
NEWS_LOGON_DEL_NONE
	 ,  !
NEWS_LOGON_DELETED_ALL
	  .

NEWS_OPER_SYNTAX
	OPERNEWS {ADD | DEL | LIST} [ | ]
NEWS_OPER_LIST_HEADER
	   :
NEWS_OPER_LIST_ENTRY
	%5d (%s  %s)
	    %s
NEWS_OPER_LIST_NONE
	   .
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD 
NEWS_OPER_ADD_FULL
	  !
NEWS_OPER_ADDED
	     (#%d).
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL { | ALL}
NEWS_OPER_DEL_NOT_FOUND
	     #%d  !
NEWS_OPER_DELETED
	     #%d .
NEWS_OPER_DEL_NONE
	   ,  !
NEWS_OPER_DELETED_ALL
	    .

NEWS_HELP_LOGON
	: LOGONNEWS ADD 
	        LOGONNEWS DEL { | ALL}
	        LOGONNEWS LIST
	
	  .  
	  IRC ,    
	. (  ,     
	,    .    
	 ,    
	 .)
	
	 LOGONNEWS LIST     IRC   
	 .  ADD  DEL   
	 .

NEWS_HELP_OPER
	: OPERNEWS ADD 
	        OPERNEWS DEL { | ALL}
	        OPERNEWS LIST
	
	    .  
	 IRC  (  /OPER),  
	  . (  ,     
	,    .    
	 ,    
	 .)
	
	 OPERNEWS LIST     IRC   
	 .  ADD  DEL   
	 .

###########################################################################
#
# StatServ messages
#
############################################################################

# General SERVERS responses
STAT_SERVERS_REMOVE_SERV_FIRST
	 %s .     IRC     .
STAT_SERVERS_SERVER_EXISTS
	 %s  .

# SERVERS command syntax
STAT_SERVERS_SYNTAX
	SERVERS  

# STATS responses
STAT_SERVERS_STATS_TOTAL
	 : %2d
STAT_SERVERS_STATS_ON_OFFLINE
	       : %2d (%d%%)  : %2d (%d%%)
STAT_SERVERS_LASTQUIT_WAS
	     : %-30s  %s

# LIST responses
STAT_SERVERS_LIST_HEADER
	                           
STAT_SERVERS_LIST_FORMAT
	%-30s %3d (%2d%%)  %3d (%2d%%)
STAT_SERVERS_LIST_RESULTS
	  -- %d/%d   .

# VIEW responses
STAT_SERVERS_VIEW_HEADER_ONLINE
	%-30s  ()
STAT_SERVERS_VIEW_HEADER_OFFLINE
	%-30s  ()
STAT_SERVERS_VIEW_LASTJOIN
	     : %s
STAT_SERVERS_VIEW_LASTQUIT
	     : %s
STAT_SERVERS_VIEW_QUITMSG
	   : %s
STAT_SERVERS_VIEW_USERS_OPERS
	        : %3d (%2d%%)  : %3d (%2d%%)
STAT_SERVERS_VIEW_RESULTS
	  -- %d/%d  .

# DELETE responses
STAT_SERVERS_DELETE_SYNTAX
	SERVERS DELETE 
STAT_SERVERS_DELETE_DONE
	   %s .

# COPY responses
STAT_SERVERS_COPY_SYNTAX
	SERVERS COPY  _
STAT_SERVERS_COPY_DONE
	  %s   %s.

# RENAME responses
STAT_SERVERS_RENAME_SYNTAX
	SERVERS RENAME  _
STAT_SERVERS_RENAME_DONE
	  %s   %s.

# USERS responses
STAT_USERS_SYNTAX
	USERS STATS
STAT_USERS_TOTUSERS
	              : %d
STAT_USERS_TOTOPERS
	                 : %d
STAT_USERS_SERVUSERS
	    : %d
STAT_USERS_SERVOPERS
	       : %d.%d


###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S   ""     
	-,  . %S    
	    .    
	 /msg %S HELP COMMANDS;    
	/msg %S ,       
	: /msg %S HELP .
NICK_HELP_EXPIRES
	
	       %s -   
	     .
NICK_HELP_WARNING
	
	:     ,   IRC
	    .
	     "" ,
	"" (   )    .
	 %S ,  ,    ().
NICK_HELP_COMMANDS
	  %S:
	
	    REGISTER    
NICK_HELP_COMMANDS_AUTH
	    AUTH         
	    SENDAUTH      
NICK_HELP_COMMANDS_IDENTIFY
	    IDENTIFY       
NICK_HELP_COMMANDS_SENDPASS
	    SENDPASS       E-mail 
NICK_HELP_COMMANDS_DROP
	    DROP         
NICK_HELP_COMMANDS_LINK
	    LINK           
	    UNLINK       
	    LISTLINKS    
NICK_HELP_COMMANDS_OLDLINK
	    LINK           
	    UNLINK         
NICK_HELP_COMMANDS_ACCESS
	    ACCESS        
NICK_HELP_COMMANDS_AJOIN
	    AJOIN         
NICK_HELP_COMMANDS_SET
	    SET         ,   kill'
	    UNSET        
	    RECOVER     ,    
	    RELEASE           RECOVER
	    GHOST       ""  ()
	    INFO          
NICK_HELP_COMMANDS_LIST
	    LIST         ,   
	    LISTEMAIL       E-mail 
NICK_HELP_COMMANDS_LISTCHANS
	    LISTCHANS    ,   
	    STATUS       ,      

NICK_HELP_REGISTER
	: %s
	
	      %S.  ,  
	 ,     SET  ACCESS,
	       .
	  ,     ;  
	,     .
	(:    !
	MYPASSWORD, MyPassword,  mypassword -   !)
NICK_HELP_REGISTER_EMAIL
	
	   E-mail    ;  
	     SET EMAIL.
NICK_HELP_REGISTER_EMAIL_REQ
	
	   E-mail    .
	   E-mail     
	SET HIDE ( /msg %S HELP SET HIDE   ).
NICK_HELP_REGISTER_EMAIL_AUTH
	
	    E-mail    ;
	%S     ,   
	  AUTH    .  
	 E-mail     
	SET HIDE ( /msg %S HELP SET HIDE   ).
NICK_HELP_REGISTER_END
	
	  :
	
	     -   .
	     ,  %S   .
	,       ,
	      5 .

NICK_HELP_AUTH
	: AUTH 
	
	      E-mail .
	 ,  E-mail , %S  
	    E-mail ,    
	    SET EMAIL.   
	 ,       
	 .     
	 ,   .

NICK_HELP_SENDAUTH
	: SENDAUTH
	
	      ,  
	    REGISTER  SET EMAIL.    
	         ,
	          .
	
	    ,
	        24 .

NICK_HELP_SENDPASS
	: SENDPASS 
	
	 E-mail     E-mail 
	 ,    .
	E-mail       AUTH.

NICK_HELP_IDENTIFY
	: IDENTIFY 
	
	 %S,     
	.    ,  
	    .   
	  ,   , 
	  REGISTER.

NICK_HELP_DROP
	: DROP 
	
	      %S.     
	     .

NICK_HELP_DROP_LINK
	
	,     ,     
	   .    
	   UNLINK.
NICK_HELP_DROP_END
	
	     ,  
	 ,    .

NICK_HELP_OLD_LINK
	: LINK  
	
	    ,       .
	   ,        
	 ,    ;     
	    (      ,
	 , ,        .
	
	    ,      
	  ,   %S UNLINK.  ,   
	      ( ,      ,
	   ).   -      , 
	     .  ,  
	  ;         
	 ,     .
	
	   ,     
	( IDENTIFY)    ,     .

NICK_HELP_LINK
	: LINK 
	
	    ,    ,  
	  .          ;
	,    ,       
	    auto-op  ,    
	     ,     .
	
	  UNLINK   .
	
	   ,     
	( IDENTIFY)  ,         .

NICK_HELP_OLD_UNLINK
	: UNLINK [ ]
	
	     .    ,  
	             
	   .   ;      .
	
	 ,       ,   .

NICK_HELP_UNLINK
	: UNLINK 
	
	  ()  ,     LINK.
	        ;      ,
	    .
	
	     " ",   
	 SET MAINNICK,       .

NICK_HELP_LISTLINKS
	: LISTLINKS
	
	   ,    .    
	     "*" .

NICK_HELP_ACCESS
	: ACCESS ADD 
	        ACCESS DEL 
	        ACCESS LIST
	
	      .   
	 ,    
	%S  ,      .  
	  IRC     ,     
	  (SET KILL)     (SECURE) ,  
	        
	   IDENTIFY.
	
	,    ADD  DEL     (*  ?).
	
	:
	
	    ACCESS ADD achurch@*.dragonfire.net
	           achurch   
	          dragonfire.net.
	
	    ACCESS DEL achurch@*.dragonfire.net
	          .
	
	    ACCESS LIST
	           .

NICK_HELP_SET
	: SET  
	
	   .    :
	
	    PASSWORD      
	    LANGUAGE    ,    
	                     
	    URL         URL   
	    EMAIL       E-mail   
	    INFO        ,      INFO
	    KILL           
	    SECURE          
	    PRIVATE         
	                   /msg %S LIST
	    HIDE           
	    TIMEZONE     ,      .
NICK_HELP_SET_OPTION_MAINNICK
	    MAINNICK    ,       
NICK_HELP_SET_END
	
	    ,     
	   (/msg %S HELP IDENTIFY   
	).
	
	 /msg %S HELP SET     
	  .

NICK_HELP_SET_PASSWORD
	: SET PASSWORD _
	
	 ,         .

NICK_HELP_SET_LANGUAGE
	: SET LANGUAGE 
	
	 ,      
	 (,      ).
	      
	 :
	

NICK_HELP_SET_URL
	: SET URL 
	
	 URL   .   URL
	 ,  -  
	      INFO.

NICK_HELP_SET_EMAIL
	: SET EMAIL 
	
	  E-mail   .  
	 ,  -  
	      INFO.

NICK_HELP_SET_INFO
	: SET INFO 
	
	     .  
	 ,  -  
	      INFO.

NICK_HELP_SET_KILL
	: SET KILL {ON | QUICK | IMMED | OFF}
	
	      
	.    ,   
	   ,       
	,    %S   
	 IRC.
	
	   QUICK,     
	  20 .   IMMED,  
	 ,       ;
	,      .
	,       .

NICK_HELP_SET_SECURE
	: SET SECURE {ON | OFF}
	
	     %S 
	 .     SECURE  
	    ,   
	  ,    ,    
	     .  ,   
	     , %S  
	    ,    
	KILL.
	
NICK_HELP_SET_PRIVATE
	: SET PRIVATE {ON | OFF}
	
	        
	%S.  C   PRIVATE    
	  ,   %S   
	 LIST. (,     , 
	   ,   INFO.)

NICK_HELP_SET_HIDE
	: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	     , 
	-   %S  INFO   .
	    E-mail  (EMAIL),  
	user@host (USERMASK)      (QUIT).
	  ,    (OFF)   (ON).

NICK_HELP_SET_TIMEZONE
	: SET TIMEZONE {UTC- | - | DEFAULT}
	
	      ( , 
	     ),  ,  
	  ,    ;  DEFAULT
	  ,      .
	    :
	
	   -  UTC ,        UTC
	     (Universal Coordinated Time,    GMT, Greenwich Mean Time).
	        "+"  "-",   
	      UTC ( - ,  - ),   
	            ":".
	
	   -    ,   "GMT"  "EDT".
	              
	          , ,     
	     ,    ,  
	        UTC.
	
	,       ;     .
	
	:
	
	    SET TIMEZONE -5
	            5   UTC.
	
	    SET TIMEZONE +3:30
	            3  30   UTC.
	
	    SET TIMEZONE JST
	            Japan Standard Time (UTC+9:00).

NICK_HELP_SET_MAINNICK
	: SET MAINNICK 
	
	     ,  ,  
	   ,       .
	     ,      .

NICK_HELP_UNSET
	: UNSET {URL | EMAIL | INFO}
	
	   URL (URL), E-mail  (EMAIL) 
	  (INFO)    .

NICK_HELP_UNSET_REQ_EMAIL
	: UNSET {URL | INFO}
	
	   URL (URL)    (INFO)
	   .

NICK_HELP_RECOVER
	: RECOVER  []
	
	    ,    -
	; ..  ,  %S  ,
	 -    .
	
	   , %S  
	  .   IRC  
	    .  
	      %s,  ,
	         ;
	       . ,   
	 RELEASE (/msg %S HELP RELEASE)    
	.
	
	   RECOVER    
	           .

NICK_HELP_RELEASE
	: RELEASE  []
	
	 %S       
	     RECOVER.
	 ,    %s;
	     .
	
	   RELEASE    
	           .

NICK_HELP_GHOST
	: GHOST  []
	
	  ""   IRC, 
	 .  ""  --  ,   
	    ,    - 
	,   .     
	       
	     IRC.
	
	   GHOST    
	           .

NICK_HELP_INFO
	: INFO  [ALL]
	
	    ,   
	 ,    ,  . 
	       
	 ALL,     , 
	 ,    .

NICK_HELP_INFO_AUTH
	
	 E-mail       AUTH,  
	  ,      ,
	    SET HIDE EMAIL.

NICK_HELP_LISTCHANS
	: LISTCHANS
	
	    .

NICK_HELP_LIST
	: LIST 
	
	    ,      
	   (  user@host)    .
	,     PRIVATE,   .
	
	:
	
	    LIST joeuser@foo.com
	           ,     
	            IRC  joeuser@foo.com.
	
	    LIST *Bot*
	              Bot    ( ).
	
	    LIST *@*.bar.org
	          ,     bar.org.

NICK_HELP_LIST_OPERSONLY
	
	 IRC     .

NICK_HELP_LISTEMAIL
	: LISTEMAIL 
	
	        LIST, 
	   E-mail .
	       LIST(/msg %S HELP LIST).

NICK_HELP_STATUS
	: STATUS ...
	
	    ;      .
	   :
	
	     -
	
	  -  ,      ,
	-    :
	
	    0 -          
	    1 -      
	    2 -         
	    3 -        
	
	 16       ;
	  .      ,
	       .

NICK_HELP_AJOIN
	: AJOIN ADD 
	        AJOIN DEL 
	        AJOIN LIST
	
	       .
	  ,      ,
	    ,     %S.
	      ,
	   "#" (     ).
	
NICK_HELP_AJOIN_END
	 ,  IRC      
	    , ,    
	 ( +k)     (+i).
NICK_HELP_AJOIN_END_CHANSERV
	 ,  IRC      
	    , ,    
	 ( +k)     (+i). ,  
	   %s  INVITE   , %S
	    .

NICK_OPER_HELP_COMMANDS
	
	    :
	
	    DROPNICK     
NICK_OPER_HELP_COMMANDS_DROPEMAIL
	    DROPEMAIL    ,    E-mail 
NICK_OPER_HELP_COMMANDS_GETPASS
	    GETPASS      
	                   (   )
NICK_OPER_HELP_COMMANDS_FORBID
	    FORBID      / 
	    SUSPEND       ()
	    UNSUSPEND   
NICK_OPER_HELP_COMMANDS_LISTLINKS
	    LISTLINKS   ,     
NICK_OPER_HELP_COMMANDS_SETAUTH
	    SETAUTH         
	    GETAUTH        
	    CLEARAUTH      
NICK_OPER_HELP_COMMANDS_END
	
	         
	   :
	
	    SET, ACCESS LIST, INFO ALL
	
	      .

NICK_OPER_HELP_DROPNICK
	: DROPNICK 
	
	          %S.
	
	   .

NICK_OPER_HELP_DROPEMAIL
	: DROPEMAIL  | -
	        DROPEMAIL-CONFIRM  | -
	
	  ,   E-mail    .
	    "-",      E-mail .
	
	      ,
	    :   
	 DROPEMAIL,   DROPEMAIL-CONFIRM    .
	 DROPEMAIL-CONFIRM     %s    
	,    DROPEMAIL.
	   4  DROPEMAIL,     
	       DROPEMAIL-CONFIRM.
	
	   .

NICK_OPER_HELP_SET
	
	      NOEXPIRE,  
	      .
	,       
	    ,  :
	SET   .

NICK_OPER_HELP_SET_NOEXPIRE
	: SET [] NOEXPIRE {ON | OFF}
	
	      -   .
	  ON    .  
	 ,  -     .
	
	   .

NICK_OPER_HELP_UNSET
	
	
	     UNSET   .
	    , ,       SET.

NICK_OPER_HELP_OLD_UNLINK
	
	         .

NICK_OPER_HELP_UNLINK
	: UNLINK  [FORCE]
	
	  ()   ,   LINK
	        ;   
	  ,     .
	
	     " ",   
	 SET MAINNICK,       .
	
	     FORCE,  
	  ,     .

NICK_OPER_HELP_OLD_LISTLINKS
	: LISTLINKS 
	
	   ,     .
	
	   .

NICK_OPER_HELP_LISTLINKS
	: LISTLINKS []
	
	   ,    .    
	     "*" .
	        ,    .

NICK_OPER_HELP_ACCESS
	
	       LIST, 
	     .

NICK_OPER_HELP_INFO
	
	     ALL   .

NICK_OPER_HELP_LISTCHANS
	
	       
	,      (, /msg %S LISTCHANS _).

NICK_OPER_HELP_LIST
	: LIST  [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	    ,      
	   (  user@host)    .
	,     PRIVATE,   
	  .     ,  
	  NOEXPIRE,    !  ,  ,   - *.
	
	    FORBIDDEN, SUSPENDED  NOEXPIRE,   
	  ,  ,     NOEXPIRE .
	
	       .
	     .
	
	:
	
	    LIST joeuser@foo.com
	           ,     
	            IRC  joeuser@foo.com.
	
	    LIST *Bot*
	              Bot    ( ).
	
	    LIST * NOEXPIRE
	           ,     NOEXPIRE.

NICK_OPER_HELP_LIST_AUTH
	: LIST  [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	    ,      
	   (  user@host)    .
	,     PRIVATE,   
	  .     ,  
	  NOEXPIRE,    !  ,
	,   - *,  ,     - ?.
	
	    FORBIDDEN, SUSPENDED  NOEXPIRE,   
	  ,  ,     NOEXPIRE .
	
	       .
	     .
	
	    FORBIDDEN, SUSPENDED, NOEXPIRE  NOAUTH,
	     ,  , ,
	  NOEXPIRE     .
	
	       .
	     .
	
	:
	
	    LIST joeuser@foo.com
	           ,     
	            IRC  joeuser@foo.com.
	
	    LIST *Bot*
	              Bot    ( ).
	
	    LIST * NOEXPIRE
	           ,     NOEXPIRE.

NICK_OPER_HELP_LISTEMAIL
	: LISTEMAIL  [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	        LIST, 
	   E-mail .
	       LIST(/msg %S HELP LIST).

NICK_OPER_HELP_LISTEMAIL_AUTH
	: LISTEMAIL  [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	        LIST, 
	   E-mail .
	       LIST(/msg %S HELP LIST).

NICK_OPER_HELP_GETPASS
	: GETPASS 
	
	   . ,  
	   ,  ,
	    ,     ,
	       WALLOPS/GLOBOPS.
	
	     ,    .
	
	   .

NICK_OPER_HELP_FORBID
	: FORBID 
	
	      .
	      (DROP).
	
	   .

NICK_OPER_HELP_SUSPEND
	: SUSPEND [+_]  
	
	 /    
	    .      
	UNSUSPEND.  _ ,     %s AKILL.
	
	   .

NICK_OPER_HELP_UNSUSPEND
	: UNSUSPEND 
	
	     , 
	  .
	
	   .

NICK_OPER_HELP_AJOIN
	
	       
	   LIST .

NICK_OPER_HELP_SETAUTH
	: SETAUTH 
	
	      .
	     AUTH   .
	  ,     
	    .
	
	   .

NICK_OPER_HELP_GETAUTH
	: GETAUTH 
	
	  ,   ,   .
	
	   .

NICK_OPER_HELP_CLEARAUTH
	: CLEARAUTH 
	
	     ,     .
	
	   .


###########################################################################
#
# ChanServ help messages
#
###########################################################################

# Used in OP/VOICE/etc for required access levels for commands
CHAN_HELP_REQSOP_LEVXOP
	 100 (SOP)
CHAN_HELP_REQSOP_LEV
	 100
CHAN_HELP_REQSOP_XOP
	SOP
CHAN_HELP_REQAOP_LEVXOP
	 50 (AOP)
CHAN_HELP_REQAOP_LEV
	 50
CHAN_HELP_REQAOP_XOP
	AOP
CHAN_HELP_REQHOP_LEVXOP
	 40 (HOP)
CHAN_HELP_REQHOP_LEV
	 40
CHAN_HELP_REQHOP_XOP
	HOP
CHAN_HELP_REQVOP_LEVXOP
	 30 (VOP)
CHAN_HELP_REQVOP_LEV
	 30
CHAN_HELP_REQVOP_XOP
	VOP

# Real help messages start here
CHAN_HELP
	%S      
	 . %S   "" 
	   ,  
	    .    
	 /msg %S HELP COMMANDS;   
	 /msg %S ,    
	   : /msg %S HELP .
CHAN_HELP_EXPIRES
	
	 ,    ,   
	  %s (..      
	       ) 
	 .

CHAN_HELP_COMMANDS
	  %S:
	
	    REGISTER    
	    IDENTIFY      
CHAN_HELP_COMMANDS_SENDPASS
	    SENDPASS      
CHAN_HELP_COMMANDS_DROP
	    DROP         
	    SET              
	    UNSET        
	    INFO             
CHAN_HELP_COMMANDS_LIST
	    LIST          
CHAN_HELP_COMMANDS_AKICK
	    AKICK       AKICK 
CHAN_HELP_COMMANDS_LEVELS
	    ACCESS         
	    LEVELS        
CHAN_HELP_COMMANDS_XOP
	    SOP          SuperOp
	    AOP          AutoOp
	    VOP          AutoVoice
CHAN_HELP_COMMANDS_HOP
	    HOP          AutoHalfop
CHAN_HELP_COMMANDS_OPVOICE
	    OP             (+o)
	    DEOP          (+o)
	    VOICE          (+v)
	    DEVOICE       (+v)
CHAN_HELP_COMMANDS_HALFOP
	    HALFOP         (+h)
	    DEHALFOP      (+h)
CHAN_HELP_COMMANDS_PROTECT
	    PROTECT        (+a)
	    DEPROTECT     (+a)
CHAN_HELP_COMMANDS_INVITE
	    INVITE        
	    UNBAN           
	    KICK          
	    TOPIC        
	    CLEAR            
	    STATUS           

CHAN_HELP_REGISTER
	: REGISTER   
	
	     %S.  , 
	  ,     
	 ,   .
	      IDENTIFY, 
	      .
	 ,    ,  
	  .
	
	   ,   
	"" .     
	 ; %S    
	   /   .
	   ACCESS (/%S HELP ACCESS)
	    ,  
	     .
	
	:  ,   ,  
	   .     
	,  /msg %s HELP  
	   .
CHAN_HELP_REGISTER_ADMINONLY
	
	   .

CHAN_HELP_SENDPASS
	: SENDPASS 
	
	  E-mail ,    
	.       
	  %s  IDENTIFY.

CHAN_HELP_IDENTIFY
	: IDENTIFY  
	
	   %S    .
	    ,   
	.     , 
	 ,    REGISTER.

CHAN_HELP_DROP
	: DROP 
	
	   .   
	  ,    
	  IDENTIFY.

CHAN_HELP_SET
	: SET   
	
	     
	 ,    .  
	  IDENTIFY  
	SET.
	
	 :
	
	    FOUNDER       
	    SUCCESSOR     
	    PASSWORD      
	    DESC          
	    URL            URL
	    EMAIL          E-mail 
	    ENTRYMSG     , 
	                       
	    KEEPTOPIC    ,    
	    TOPICLOCK      
	    MLOCK         
	    PRIVATE          LIST
	    RESTRICTED     
	    SECURE         %S  
	    SECUREOPS      
	    LEAVEOPS       
	    OPNOTICE        OP/DEOP
	    ENFORCE          
	
	 /msg %S HELP SET    
	   .

CHAN_HELP_SET_FOUNDER
	: SET  FOUNDER 
	
	  .    
	 .

CHAN_HELP_SET_SUCCESSOR
	: SET  SUCCESSOR 
	
	  .    
	  ,   , 
	   .   , 
	      (%d),
	  , ,       .
	     .

CHAN_HELP_SET_PASSWORD
	: SET  PASSWORD 
	
	 ,   
	    .

CHAN_HELP_SET_DESC
	: SET  DESC 
	
	  ,     
	 LIST  INFO.

CHAN_HELP_SET_URL
	: SET  URL url
	
	  URL  .  URL
	 ,  -    
	   INFO.

CHAN_HELP_SET_EMAIL
	: SET  EMAIL 
	
	  E-mail   .  
	 ,  -    
	   INFO.

CHAN_HELP_SET_ENTRYMSG
	: SET  ENTRYMSG 
	
	 ,     (/NOTICE)
	    .

CHAN_HELP_SET_KEEPTOPIC
	: SET  KEEPTOPIC {ON | OFF}
	
	      
	.    ,  
	  %S   ,  
	  ,   
	  -  .

CHAN_HELP_SET_TOPICLOCK
	: SET  TOPICLOCK {ON | OFF}
	
	       .
	   , %S   
	      TOPIC.

CHAN_HELP_SET_MLOCK
	: SET  MLOCK 
	
	     . %S
	    ,   
	  ( ).   
	(n, s, t, k, l  ..)   ;
	       ,
	      .
	     
	/MODE; ,   +  
	 ,  ,   -   .
	
	:       ,   
	 ,      RESTRICTED
	  (. HELP SET RESTRICTED),  ,    
	      !
	  +i         .
	
	:
	
	    SET # MLOCK +nt-ikl
	           n  t,   i, k  l.
	            / .
	
	    SET # MLOCK +knst-ilmp -
	           k, n, s,  t,   i, l, m,  p.
	               "-".
	
	    SET # MLOCK +
	          ;      
	        .

CHAN_HELP_SET_HIDE
	: SET  HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
	
	     ,  -
	  %S  INFO   .
	   E-mail   (EMAIL),   (TOPIC)
	   (MLOCK).
	  ,    (OFF)   (ON).
	
	,     ,  
	  +p  +s.

CHAN_HELP_SET_PRIVATE
	: SET  PRIVATE {ON | OFF}
	
	      .
	  ,  /msg %S LIST  
	   .

CHAN_HELP_SET_RESTRICTED
	: SET  RESTRICTED {ON | OFF}
	
	     
	.    , ,
	           
	 ,       .

CHAN_HELP_SET_SECURE
	: SET  SECURE {ON | OFF}
	
	     %S 
	.  SECURE ,  
	     %s 
	         .
	    RESTRICTED,    
	    %s .

CHAN_HELP_SET_SECUREOPS
	: SET  SECUREOPS {ON | OFF}
	
	      .
	    , 
	          .

CHAN_HELP_SET_LEAVEOPS
	: SET  LEAVEOPS {ON | OFF}
	
	      .
	    , %S  
	  (+o ,     )
	       .
	 SECUREOPS     .
	
	:      ""
	   .

CHAN_HELP_SET_OPNOTICE
	: SET  OPNOTICE {ON | OFF}
	
	   -  .
	 - , %S   
	   -   OP, VOICE
	    .

CHAN_HELP_SET_ENFORCE
	: SET  ENFORCE {ON | OFF}
	
	     .
	  , %S  
	  -  -   .
	 ,     -
	 , %S    . %S
	     DEOP   .

CHAN_HELP_UNSET
	: UNSET  {SUCCESSOR | URL | EMAIL | ENTRYMSG}
	
	    .

CHAN_HELP_SOP
	: SOP  ADD 
	        SOP  DEL 
	        SOP  LIST [ | ]
	        SOP  COUNT
	
CHAN_HELP_SOP_MID1
	   (SOP) . 
	  SOP     ( +o)
	    .
CHAN_HELP_SOP_MID1_CHANPROT
	   (SOP) . 
	  SOP     ( +o)
	  ( +a)     .
CHAN_HELP_SOP_MID2
	
	SOP'    AOP'  VOP'.       SOP'.
CHAN_HELP_SOP_MID2_HALFOP
	
	SOP'    AOP', HOP'  VOP'.       SOP'.
CHAN_HELP_SOP_END
	
	 SOP LIST   SOP'.   ,
	     ,    .
	    ,     ; :
	
	   SOP # LIST 2-5,7-9
	       SOP',   2  5  
	      7  9.
	
	 SOP COUNT     SOP .

CHAN_HELP_AOP
	: AOP  ADD 
	        AOP  DEL 
	        AOP  LIST [ | ]
	        AOP  COUNT
	
	   (AOP) . 
	  AOP     ( +o)
	    .

CHAN_HELP_AOP_MID
	
	AOP'    VOP'. SOP'    AOP'.
CHAN_HELP_AOP_MID_HALFOP
	
	AOP'    HOP'  VOP'. SOP'    AOP'.
CHAN_HELP_AOP_END
	
	 AOP LIST   AOP'.   ,
	     ,    .
	    ,     ; :
	
	   AOP # LIST 2-5,7-9
	       AOP',   2  5  
	      7  9.
	
	 AOP COUNT     AOP .

CHAN_HELP_HOP
	: HOP  ADD 
	        HOP  DEL 
	        HOP  LIST [ | ]
	        HOP  COUNT
	
	   (HOP) . 
	  HOP     ( +h)
	    .
	
	HOP'    VOP'. SOP'  AOP'    HOP'.
	
	 HOP LIST   HOP'.   ,
	     ,    .
	    ,     ; :
	
	   HOP # LIST 2-5,7-9
	       HOP',   2  5  
	      7  9.
	
	 HOP COUNT     HOP .

CHAN_HELP_VOP
	: VOP  ADD 
	        VOP  DEL 
	        VOP  LIST [ | ]
	        VOP  COUNT
	
	   () (VOP) . 
	  VOP     ( +v)
	    .
	
	 VOP LIST   VOP'.   ,
	     ,    .
	    ,     ; :
	
	   VOP # LIST 2-5,7-9
	       VOP',   2  5  
	      7  9.
	
	 VOP COUNT     VOP .

CHAN_HELP_ACCESS
	: ACCESS  ADD  
	        ACCESS  DEL { |   | }
	        ACCESS  LIST [ | ]
	        ACCESS  COUNT
	
	   .  
	,      ,
	    %S  .   
	        
	; /msg %S HELP ACCESS LEVELS   
	 . ,      ,
	     0.
	
	 ACCESS ADD    
	    ;    
	   ,      
	  .     ,
	  ,   , 
	      , 
	      ,   
	,   .
	
	 ACCESS DEL    
	 .    ,  
	 . (.    LIST .)
	
	 ACCESS LIST   . 
	 ,      
	 .    ,  
	   ; :
	
	   ACCESS # LIST 2-5,7-9
	         2  5  
	   7  9.
	
	 ACCESS COUNT      .
CHAN_HELP_ACCESS_XOP
	
	,      SOP, AOP  VOP ,
	    %d, %d  %d .
CHAN_HELP_ACCESS_XOP_HALFOP
	
	,      SOP, AOP, HOP  VOP ,
	    %d, %d, %d  %d .

CHAN_HELP_ACCESS_LEVELS
	  
	
	 ,     :
	
	   Founder       %S;  
	                      . ,
	                       
	                  (      ACCESS).
	      %4d      AKICK; .
	      %4d   .
CHAN_HELP_ACCESS_LEVELS_HALFOP
	      %4d   .
CHAN_HELP_ACCESS_LEVELS_END
	      %4d   .
	         0     ;    
	                  (   SECUREOPS ).
	        -1        .
	      -100       .
	
	  (  )      , 
	 LEVELS;  /msg %S HELP LEVELS    .

CHAN_HELP_LEVELS
	: LEVELS  SET  
	        LEVELS  {DIS | DISABLE} 
	        LEVELS  LIST
	        LEVELS  RESET
	
	 LEVELS    
	,   ACCESS.  
	,     ,   
	 %S'. ( SET FOUNDER  SET PASSWORD,
	    ,   
	 .)
CHAN_HELP_LEVELS_XOP
	
	:       !
	        
	  SOP, AOP  VOP   .
CHAN_HELP_LEVELS_XOP_HOP
	
	:       !
	        
	  SOP, AOP, HOP  VOP   .
CHAN_HELP_LEVELS_END
	
	LEVELS SET        .
	LEVELS DISABLE ( DIS)     
	  ,   . LEVELS LIST  
	       .
	LEVELS RESET      
	   (. HELP ACCESS LEVELS).
	
	   ,      ,
	. HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	 / :

CHAN_HELP_AKICK
	: AKICK  ADD  []
	        AKICK  DEL 
	        AKICK  LIST [ | ]
	        AKICK  VIEW [ | ]
	        AKICK  ENFORCE
	        AKICK  COUNT
	
	   .  ,
	       ,
	%S    ,    .
	
	 AKICK ADD  user@host  nick!user@host 
	  .   ,    ,
	   ;    ,
	    : "You have been banned from the channel".
	
	 AKICK DEL      .
	  ,      ;    
	.
	
	 AKICK LIST    , 
	    ,   
	 .  AKICK VIEW ,  
	 .
	
	 AKICK ENFORCE  %S   AKICK
	     ,   .
	
	 AKICK COUNT     AKICK .
	
	 ,      %s  .

CHAN_HELP_INFO
	: INFO  [ALL]
	
	     ,
	  ,  ,   
	 ,    ,   .
	     ,   
	ALL        .

CHAN_HELP_LIST
	: LIST 
	
	      .
	(    PRIVATE   .)
CHAN_HELP_LIST_OPERSONLY
	
	 IRC     .

CHAN_HELP_OP
	: OP  []
	
	        .
	   ,      .
	 ,       ,  %s  .
	
CHAN_HELP_DEOP
	: DEOP  []
	
	         .
	   ,     .
	 ,         %s  .

CHAN_HELP_VOICE
	: VOICE  []
	
	 ()     .    ,    .
	 ,       ,  %s  .

CHAN_HELP_DEVOICE
	: DEVOICE  []
	
	       .    ,
	   .  ,  
	      %s  .

CHAN_HELP_HALFOP
	: HALFOP  []
	
	        .
	   ,      .
	 ,       ,  %s  .
	
CHAN_HELP_DEHALFOP
	: DEHALFOP  []
	
	        .    ,
	    .  ,  
	      %s  .

CHAN_HELP_PROTECT
	: PROTECT  []
	
	  ( +a)      .    ,
	   .  ,  
	      %s  .

CHAN_HELP_DEPROTECT
	: DEPROTECT  []
	
	  ( +a)      .
	   ,    .
	 ,       ,  %s  .

CHAN_HELP_INVITE
	: INVITE 
	
	 %S     .
	 ,       ,  %s  .
	
	,       ,    , 
	,             .

CHAN_HELP_UNBAN
	: UNBAN 
	
	 %S      ,  
	   .  ,    
	    %s  .

CHAN_HELP_KICK
	: KICK   []
	
	 %S      .
	   ,       ,
	  ,      .
	          %s  .

CHAN_HELP_KICK_PROTECTED
	
	,   (+a)       
	 ,     .

CHAN_HELP_TOPIC
	: TOPIC  
	
	 %S   .   
	     SET TOPICLOCK.  , 
	       %s  .

CHAN_HELP_CLEAR
	: CLEAR  
	
	 %S     .      :
	
	    MODES          ,  ,  .
	    BANS            .
CHAN_HELP_CLEAR_EXCEPTIONS
	    EXCEPTIONS        .
CHAN_HELP_CLEAR_INVITES
	    INVITES          .
CHAN_HELP_CLEAR_MID
	    OPS             ( +o)   .
CHAN_HELP_CLEAR_HALFOPS
	    HALFOPS         ( +h)   .
CHAN_HELP_CLEAR_END
	    VOICES          ( +v)   .
	    USERS        ()    .
	
	 ,         %s  .

CHAN_HELP_STATUS
	: STATUS  
	
	     
	  .   :
	
	    STATUS   
	
	  ,     :
	
	    STATUS   ERROR 
	
	 ,         %s  .

CHAN_OPER_HELP_COMMANDS
	
	    :
	
CHAN_OPER_HELP_COMMANDS_GETPASS
	    GETPASS        
	                   (   )
CHAN_OPER_HELP_COMMANDS_FORBID
	    FORBID      / 
	    SUSPEND       
	    UNSUSPEND     
CHAN_OPER_HELP_COMMANDS_END
	
	         
	   ,    
	 , AKICK      STATUS 
	 .

CHAN_OPER_HELP_DROP
	: DROP 
	
	   .   
	  ,     .

CHAN_OPER_HELP_SET
	
	      NOEXPIRE,  
	      .
	,       
	     .

CHAN_OPER_HELP_SET_NOEXPIRE
	: SET  NOEXPIRE {ON | OFF}
	
	      -   .
	  ON    .
	
	   .

CHAN_OPER_HELP_UNSET
	
	     SET,    
	          .

CHAN_OPER_HELP_INFO
	
	     ALL   .

CHAN_OPER_HELP_LIST
	: LIST  [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	     , 
	  .     PRIVATE  
	  .     NOEXPIRE
	       !  .
	
	    FORBIDDEN, SUSPENDED  NOEXPIRE,
	     ,  , 
	   NOEXPIRE .     
	  .
	      .

CHAN_OPER_HELP_GETPASS
	: GETPASS 
	
	    . ,  
	  , ,  ,
	    ,     ,
	       WALLOPS/GLOBOPS.
	
	     ,    .
	
	   .

CHAN_OPER_HELP_FORBID
	: FORBID 
	
	      .
	     .
	
	   .

CHAN_OPER_HELP_SUSPEND
	: SUSPEND [+_]  
	
	 /   .
	      UNSUSPEND.
	 _ ,     %s AKILL.
	
	   .

CHAN_OPER_HELP_UNSUSPEND
	: UNSUSPEND 
	
	     , 
	  .
	
	   .


###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	
	%S    IRC 
	  (  - ) 
	,        
	  ,   (*);  
	       
	   .    
	 /msg %S HELP COMMANDS;    
	/msg %S ,       
	: /msg %S HELP .

MEMO_HELP_EXPIRES
	
	:    ( )  
	%s  ,   ,     
	  SAVE.
MEMO_HELP_END_LEVELS
	
	(*)  ,        %s 
	        .    
	        %s LEVELS.
MEMO_HELP_END_XOP
	
	(*)     SOP'     .

MEMO_HELP_COMMANDS
	  %S:
	
	    SEND           
	    LIST         
	    READ          
MEMO_HELP_COMMANDS_FORWARD
	    FORWARD       E-mail 
MEMO_HELP_COMMANDS_SAVE
	    SAVE         
MEMO_HELP_COMMANDS_DEL
	    DEL           
	    SET         
	    INFO         
MEMO_HELP_COMMANDS_IGNORE
	    IGNORE        

MEMO_HELP_SEND
	: SEND { | } -
	
	      #, 
	-.   ,    ,
	   / . ,     ,
	  .

MEMO_HELP_LIST
	: LIST [] [ |  | NEW]
	
	   .   NEW,  
	 () .        "*"
	   .     
	,  :
	
	   LIST 2-5,7-9
	         2  5   7  9.

MEMO_HELP_LIST_EXPIRE
	: LIST [] [ |  | NEW]
	
	   .   NEW,  
	 () .        "*"
	   , ,   ,    "+".
	     ,  :
	
	   LIST 2-5,7-9
	         2  5   7  9.

MEMO_HELP_READ
	: READ [] { |  | LAST | NEW}
	
	   ,   .    LAST,  
	 .    NEW,      .
	       .     
	, ,       LIST.

MEMO_HELP_SAVE
	: SAVE [] { | }
	
	        .  
	   , ,      LIST,  .

MEMO_HELP_DEL
	: DEL [] { |  | ALL}
	
	      .    
	      ,    LIST; 
	    ALL,  ,      .
	
	:   ,   !

MEMO_HELP_SET
	: SET  
	
	     .     :
	
	    NOTIFY         
	                       (  )
	    LIMIT           , 
	                      
MEMO_HELP_SET_OPTION_FORWARD
	    FORWARD         
MEMO_HELP_SET_END
	
	 /msg %S HELP SET      
	  .

MEMO_HELP_SET_NOTIFY
	: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	      :
	
	    ON               ,
	                     /AWAY    -   .
	    LOGON             
	                      /AWAY.
	    NEW             
	                 .
	    OFF            .
	
	ON   LOGON  NEW.
	
	,     " (secure)",  
	 ( LOGON  ON)   ,    %s.

MEMO_HELP_SET_LIMIT
	: SET LIMIT [] 
	
	   ,   ( )
	 .      0,  
	    . ,     
	,  %d.

MEMO_HELP_INFO
	: INFO []
	
	      , 
	  ,       
	        .
	        .

MEMO_OPER_HELP_COMMANDS
	
	
	     SET  INFO   .

MEMO_OPER_HELP_SET_LIMIT
	: SET LIMIT [ | ] { | NONE | DEFAULT} [HARD]
	
	   ,   ( )
	 .    0   
	  ;   NONE 
	     ,    
	  DEFAULT     (%d). 
	     ,     
	.
	
	 HARD     . 
	HARD   -   , ..  
	  (       
	HARD).
	
	 SET LIMIT    
	.        
	  ,       ,  
	      ,      %d
	     HARD.

MEMO_OPER_HELP_INFO
	: INFO [ | ]
	
	     ,
	   ,       
	        .
	
	  ,    ,   .
	  ,    ,   .
	
	   .

MEMO_HELP_FORWARD
	: FORWARD { |  | ALL}
	
	       E-mail .
	    E-mail    ,    .
	    .

MEMO_HELP_SET_FORWARD
	: SET FORWARD {ON | COPY | OFF}
	
	,   %S     E-mail
	 ,  .    ON,  ,  , 
	     E-mail ,    .
	 COPY ,    %S     .
	   OFF,      .  
	    ON,           
	   .
	
	,      COPY     
	 ,       ,  E-mail,
	        DEL.

MEMO_HELP_IGNORE
	: IGNORE {ADD | DEL | LIST} [ | ]
	
	  "" ; ,  
	 user@host       ,    
	 .  ADD     user@host    
	, DEL       ; LIST 
	   .
	
	,        "*"  "?" 
	  ;  , "*Evil*"   "EvilNick", "AN_EVIL_USER" 
	"devil".


###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	%S   IRC     IRC .
	 /msg %S HELP COMMANDS    .
	
	:  ,   %S !

OPER_HELP_COMMANDS
	%S :
	    GLOBAL         
	    STATS           
	    SERVERMAP      
	    OPER LIST     
	    ADMIN LIST    
OPER_HELP_COMMANDS_SERVOPER
	
	,      :
	    MODE           
	    KICK           
	    CLEARMODES     
	    CLEARCHAN        (masskick)
	    KILLCLONES       
OPER_HELP_COMMANDS_AKILL
	    AKILL         AKILL'
	    AKILLCHAN   Autokill    
OPER_HELP_COMMANDS_EXCLUDE
	    EXCLUDE         AKILL'
OPER_HELP_COMMANDS_SLINE
	    SGLINE        SGLINE'
	    SQLINE        SQLINE'
	    SZLINE        SZLINE'
OPER_HELP_COMMANDS_SESSION
	    SESSION        
	    EXCEPTION        
OPER_HELP_COMMANDS_NEWS
	    LOGONNEWS        
	    OPERNEWS     ,  IRC 
OPER_HELP_COMMANDS_SERVADMIN
	
	,    :
	    OPER           
	    JUPE        "" 
	    SET            
	    UPDATE         
	                        
	    SHUTDOWN         
	    QUIT             
	    RESTART          
	    REHASH        
	    SU             
OPER_HELP_COMMANDS_SERVROOT
	
	,    :
	    ADMIN          
OPER_HELP_COMMANDS_RAW
	    RAW          raw   IRC 

OPER_HELP_GLOBAL
	: GLOBAL 
	
	 IRC      IRC .
	      %s.

OPER_HELP_STATS
	: STATS [RESET | NETWORK | ALL]
	
	 ,     
	IRC    ( ),   
	    ,    .
	
	 RESET     
	   .
	
	  NETWORK   ,   
	    ,   /.
	         
	 ,    .
	
	 ALL       
	   .     
	       ,     !
	
	UPTIME    STATS.

OPER_HELP_SERVERMAP
	: SERVERMAP
	
	  ,       .
	"" --    ,  
	 JUPE --   "(*)"   .

OPER_HELP_OPER
	: OPER ADD 
	        OPER DEL 
	        OPER LIST
	
	        
	 . ,     
	 ,   %s  
	   .
	
	 OPER ADD       .
	 OPER DEL       .
	 OPER LIST    .
	
	 IRC     OPER LIST.
	       .

OPER_HELP_ADMIN
	: ADMIN ADD 
	        ADMIN DEL 
	        ADMIN LIST
	
	      
	   . ,  
	       
	 %s      .
	
	 ADMIN ADD       .
	 ADMIN DEL       .
	 ADMIN LIST    .
	
	 IRC     ADMIN LIST.
	       .

OPER_HELP_MODE
	: MODE  
	
	       .
	    ,    
	 /MODE.
	
	   .

OPER_HELP_CLEARMODES
	: CLEARMODES channel [ALL]
	
	    (n,s,t,k,l,   )    
	.    ALL,        ,
	 ( +o  +v)  .
	
	   .

OPER_HELP_CLEARCHAN
	: CLEARCHAN 
	
	     (masskick)
	
	   .

OPER_HELP_KICK
	: KICK   
	
	 IRC      .
	    ,      /KICK.
	     IRC ,  
	   , :
	
	*** SpamMan has been kicked off channel #my_channel by %S (Alcan ())
	
	   .

OPER_HELP_AKILL
	: AKILL ADD [+_]  
	        AKILL DEL 
	        AKILL LIST [] [NOEXPIRE]
	        AKILL VIEW [] [NOEXPIRE]
	        AKILL COUNT
	
	     AKILL'. 
	,    AKILL'  , 
	   KILL, ,   IRC   ,
	   IRC    (K-line)    .
	
	AKILL ADD    user@host   AKILL'
	   (    ).
	AKILL DEL      AKILL'.
	AKILL LIST    AKILL';   ,
	      .
	AKILL VIEW    ,  AKILL LIST,  
	,   AKILL,   AKILL', 
	 ,       user@host   AKILL'.
	
	   NOEXPIRE,      , 
	      user@host .
	AKILL COUNT     .
	
	, _      AKILL ADD.
	_   user@host       
	d(), h()  m().     ( 1h30m).
	    ,       ""
	(  +30   30 ).    AKILL,
	    +0.       +,
	    ,       .
	
	     ;     ,
	      KILL .
OPER_HELP_AKILL_OPERMAXEXPIRY
	
	    _   %s;
	     .
OPER_HELP_AKILL_END
	
	   .

OPER_HELP_AKILLCHAN
	: AKILLCHAN [KILL] [+_]  
	
	 autokills     IRC    ,
	,    KILL,    .
	    ,      kill 
	    .
	_     ,     AKILL ADD;
	  ,     %s.
	
	Autokills,      *@hostname,   
	  .   autokill    ,    ;
	   ,    autokills   ,
	    .
	
	   .

OPER_HELP_EXCLUDE
	: EXCLUDE ADD [+_]  
	        EXCLUDE DEL 
	        EXCLUDE LIST [] [NOEXPIRE]
	        EXCLUDE VIEW [] [NOEXPIRE]
	        EXCLUDE COUNT
	
	     AKILL .  
	   ,      ,    
	KILL         autokill.  ,  
	  autokill   ,     , 
	  ,    .
	
	 ADD, DEL, LIST, VIEW,  COUNT  ,   
	 AKILL;     AKILL   .
	
	   .

OPER_HELP_SGLINE
	: SGLINE ADD [+_]  
	        SGLINE DEL 
	        SGLINE LIST [] [NOEXPIRE]
	        SGLINE VIEW [] [NOEXPIRE]
	        SGLINE COUNT
	
	     SGLINE'. 
	,  " "   SGLINE , 
	,     KILL ,   , 
	    (G-line)   .
	
	
	SGLINE ADD       SGLINE  
	  (    ).
	SGLINE DEL      SGLINE'.
	SGLINE LIST    SGLINE';   ,
	      .
	SGLINE VIEW    ,  SGLINE LIST,  
	,   SGLINE,   SGLINE',    ,
	       .    NOEXPIRE,   
	  ,        . SGLINE COUNT
	    .
	
	         ,   ,  :
	    /msg %S SGLINE ADD +0 "bad name"     .
	
	,  _       SGLINE ADD.
	_   user@host        d(),
	h()  m().     ( 1h30m).
	    ,       ""
	(  +30   30 ).    SGLINE,
	    +0.       +,
	     _,      ,
	   .
	
	     ;     ,
	      KILL .
	
	   .

OPER_HELP_SQLINE
	: SQLINE ADD [+_]  
	        SQLINE DEL 
	        SQLINE LIST [] [NOEXPIRE]
	        SQLINE VIEW [] [NOEXPIRE]
	        SQLINE COUNT
	
OPER_HELP_SQLINE_KILL
	
	     SQLINE'. 
	,     SQLINE  
	       ,  
	  KILL, ,   , 
	    (Q-line)    .
OPER_HELP_SQLINE_NOKILL
	     SQLINE'. 
	,     SQLINE  
	       ,  
	   ""    ,    
	    .   ,  
	    (Q-line)   .
OPER_HELP_SQLINE_IGNOREOPERS
	
	IRC       SQLINE .
OPER_HELP_SQLINE_END
	
	 ADD, DEL, LIST, VIEW,  COUNT   
	 ,   (   )  
	   SQLINE .     SGLINE
	(/msg %S HELP SGLINE)   .
	
	   .

OPER_HELP_SZLINE
	: SZLINE ADD [+_]  
	        SZLINE DEL 
	        SZLINE LIST [] [NOEXPIRE]
	        SZLINE VIEW [] [NOEXPIRE]
	        SZLINE COUNT
	
	     SZLINE'. 
	,  IP    SZLINE , 
	,     KILL ,  
	,      (Z-line)   .
	
	 ADD, DEL, LIST, VIEW,  COUNT   
	 ,   (   )  
	   SZLINE .     SGLINE
	(/msg %S HELP SGLINE)   .
	
	   .

OPER_HELP_EXCEPTION
	: EXCEPTION ADD [+_]   
	        EXCEPTION DEL { | }
	        EXCEPTION MOVE  _
	        EXCEPTION LIST [ | ]
	        EXCEPTION VIEW [ | ]
	
	     ,  
	  ,    
	   IRC  .   
	  ,        .
	 ,   ,     /NOTICE
	 %S       . 
	       .
	
	EXCEPTION ADD       . , 
	   nick ! user @ host  user@host !
	   ,     box.host.dom  *.host.dom,
	,            .
	   ,    ;  ,  
	     ( ,    
	  ).
	
	, _      EXCEPTION ADD.
	_          d(),
	h()  m().     ( 1h30m).
	    ,       ""
	(  +30   30 ).    AKILL,
	    +0.       +,
	    ,       .
	
	EXCEPTION DEL         
	  (     VIEW  LIST).
	
	EXCEPTION MOVE           _.
	 _  ,    ,  .
	
	EXCEPTION LIST  EXCEPTION VIEW    ;
	  ,  ,   .  
	    ,  EXCEPTION VIEW   
	,   ,   ,  ,  ,
	   ,      " ", ..
	,  -       .
	
	,       
	   .        
	   .
	
	   .

OPER_HELP_SESSION
	: SESSION LIST 
	        SESSION VIEW 
	
	     .
	
	SESSION LIST   ,    
	 ,   .       1, 
	       .
	
	SESSION VIEW      , 
	    .
	      .
	
	   EXCEPTION,       
	        .
	
	   .

OPER_HELP_SU
	: SU 
	
	   ,     .
	    ,     SET SUPASS; ,  
	       .  
	     IRC.
	
	:     ,    
	 IRC .
	
	   .

OPER_HELP_SET
	: SET  
	
	    .   :
	    READONLY     -  -
	    DEBUG      /  
	    SUPASS         SU ()
	
	      ;  SUPASS
	     .

OPER_HELP_SET_READONLY
	: SET READONLY {ON | OFF}
	
	    -.   -
	      ,
	      ,   . IRC 
	       
	AKILL'       ,    
	  ,   -   
	       .
	
	      
	-readonly.

OPER_HELP_SET_DEBUG
	: SET DEBUG {ON | OFF | }
	
	/  .   ,  ,  
	  IRC ,       
	    .   ,  
	   ,    .
	
	      
	-debug.

OPER_HELP_SET_SUPASS
	: SET SUPASS []
	
	 ,      SU.
	        
	 SU.    ,   SU .
	
	      .

OPER_HELP_JUPE
	: JUPE  []
	
	 ,     -  
	 ""   , 
	         . 
	  ,    SQUIT.
	  ,     ,
	  ;   , 
	     "Jupitered by <>",
	   ,    .
	
	        ,
	   .
	
	   .

OPER_HELP_RAW
	: RAW 
	
	     IRC ,    .
	        
	      .
	        ,   !
	
	   .

OPER_HELP_UPDATE
	: UPDATE [FORCE]
	
	        
	   .    FORCE, 
	      ,
	    "databases are locked"   .
	
	   .

OPER_HELP_QUIT
	: QUIT
	
	     ;  
	  .       
	    ,       .
	      SHUTDOWN.
	
	   .

OPER_HELP_SHUTDOWN
	: SHUTDOWN
	
	        .
	
	   .

OPER_HELP_RESTART
	: RESTART
	
	       
	(..         ).
	
	   .

OPER_HELP_REHASH
	: REHASH
	
	        .
	 ,  RemoteServer (   IRC ,
	   ),      REHASH  
	      ;   
	        .
	
	      LoadModule  
	  (%s),  
	   .
	,      LoadModule   
	 ; ,     ,
	      ,  
	  .
	     ,    .
	
	,  -     ,    
	     REHASH;       ,
	    .
	
	   .

OPER_HELP_KILLCLONES
	: KILLCLONES 
	
	  ,    ,    .
	  AKILL,   *@host,  
	   .
	       WALLOPS,
	   ,   ,     
	   .     ,
	    IRC .
	
	   .


###########################################################################
#
# StatServ help messages
#
###########################################################################

STAT_HELP
	%S     IRC ,
	  .
	     /msg %S HELP COMMANDS;
	       : /msg %S HELP .

STAT_HELP_COMMANDS
	   c %S:
	
	    SERVERS      
	    USERS        

STAT_HELP_SERVERS
	: SERVERS STATS
	        SERVERS LIST []
	        SERVERS VIEW [] [ONLINE | OFFLINE]
	
	 ,    .
	
	SERVERS STATS     , 
	 (),  () .
	SERVERS LIST           .
	SERVERS VIEW         
	   .   ONLINE  OFFLINE , 
	    .
	
	      .

STAT_HELP_USERS
	: USERS STATS
	
	 ,    .

STAT_OPER_HELP_SERVERS
	: SERVERS STATS
	        SERVERS LIST []
	        SERVERS VIEW [] [ONLINE | OFFLINE]
	        SERVERS DELETE 
	        SERVERS COPY  _
	        SERVERS RENAME  _
	
	 ,    .
	
	SERVERS STATS     , 
	 (),  () .
	SERVERS LIST           .
	SERVERS VIEW         
	   .   ONLINE  OFFLINE , 
	    .
	
	      .
	
	DELETE     .
	COPY    .
	RENAME     .
	
	      .
