/* Header for extsyms.c.
 *
 * IRC Services is copyright (c) 1996-2007 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef EXTSYMS_H
#define EXTSYMS_H

/*************************************************************************/

#include "modules/nickserv/nickserv.h"
#include "modules/chanserv/chanserv.h"
#include "modules/operserv/maskdata.h"
#include "modules/statserv/statserv.h"

#define DEFINE_LOCAL_VAR(sym)  extern typeof(sym) __dblocal_get_##sym(void)
#define DEFINE_LOCAL_FUNC(sym)  extern typeof(sym) *__dblocal_##sym

DEFINE_LOCAL_VAR(CSMaxReg);
DEFINE_LOCAL_VAR(MSMaxMemos);
DEFINE_LOCAL_FUNC(_get_ngi);
DEFINE_LOCAL_FUNC(_get_ngi_id);
DEFINE_LOCAL_FUNC(check_expire_nick);
DEFINE_LOCAL_FUNC(check_expire_channel);
DEFINE_LOCAL_FUNC(reset_levels);
DEFINE_LOCAL_FUNC(check_expire_maskdata);
DEFINE_LOCAL_FUNC(new_serverstats);
DEFINE_LOCAL_FUNC(free_serverstats);

#ifndef IN_EXTSYMS_C
# define CSMaxReg		((*__dblocal_get_CSMaxReg)())
# define MSMaxMemos		((*__dblocal_get_MSMaxMemos)())
# define _get_ngi		(*__dblocal__get_ngi)
# define _get_ngi_id		(*__dblocal__get_ngi_id)
# define check_expire_nick	(*__dblocal_check_expire_nick)
# define check_expire_channel	(*__dblocal_check_expire_channel)
# define reset_levels		(*__dblocal_reset_levels)
# define check_expire_maskdata	(*__dblocal_check_expire_maskdata)
# define new_serverstats	(*__dblocal_new_serverstats)
# define free_serverstats	(*__dblocal_free_serverstats)
#endif

extern int init_extsyms(const char *name);
extern void exit_extsyms(void);

/*************************************************************************/

#endif /* EXTSYMS_H */
