/* Include file for high-level encryption routines.
 *
 * IRC Services is copyright (c) 1996-2009 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

/*************************************************************************/

/* Encrypt string `src' of length `len', placing the result in buffer
 * `dest' of size `size'.  Returns 0 on success, -1 on error.
 */
extern int (*encrypt)(const char *src, int len, char *dest, int size);

/* Encrypt null-terminated string stored in buffer `buf' of size `size',
 * placing the result in the same buffer.  Returns 0 on success, -1 on
 * error.
 */
extern int (*encrypt_in_place)(char *buf, int size);

/* Check whether the result of encrypting a password of length `passlen'
 * will fit in a buffer of size `bufsize'.  Returns 0 if the encrypted
 * password would fit in the buffer, otherwise returns the maximum length
 * password that would fit (this value will be smaller than `passlen').
 * If the result of encrypting even a 1-byte password would exceed the
 * specified buffer size, generates a fatal error.
 */
extern int (*encrypt_check_len)(int passlen, int bufsize);

/* Decrypt encrypted string `src' into buffer `dest' of length `len'.
 * Returns 1 (not 0) on success, 0 if the encryption algorithm does not
 * allow decryption, and -1 if another failure occurred (e.g. destination
 * buffer too small).
 */
extern int (*decrypt)(const char *src, char *dest, int size);

/* Check an input password `plaintext' against a stored, encrypted password
 * `password'.  Return value is:
 *     1 if the password matches
 *     0 if the password does not match
 *    -1 if an error occurred while checking
 */
extern int (*check_password)(const char *plaintext, const char *password);

/*************************************************************************/

/* Restore all functions to their default handlers.  Can be used by modules
 * when unloaded.
 */
extern void reset_encrypt(void);

/*************************************************************************/
